/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.chat_style;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.ChatTypeDecoration;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class CustomChatTypeRegistry {
    public static ResourceKey<ChatType> CHAT;
    public static ResourceKey<ChatType> SAY_COMMAND;
    public static ResourceKey<ChatType> MSG_COMMAND_INCOMING;
    public static ResourceKey<ChatType> MSG_COMMAND_OUTGOING;
    public static ResourceKey<ChatType> TEAM_MSG_COMMAND_INCOMING;
    public static ResourceKey<ChatType> TEAM_MSG_COMMAND_OUTGOING;
    public static ResourceKey<ChatType> EMOTE_COMMAND;
    public static final String CHAT_PATH = "chat";
    public static final String SAY_COMMAND_PATH = "say_command";
    public static final String EMOTE_COMMAND_PATH = "emote_command";
    public static final String MSG_COMMAND_INCOMING_PATH = "msg_command_incoming";
    public static final String MSG_COMMAND_OUTGOING_PATH = "msg_command_outgoing";
    public static final String TEAM_MSG_COMMAND_INCOMING_PATH = "team_msg_command_incoming";
    public static final String TEAM_MSG_COMMAND_OUTGOING_PATH = "team_msg_command_outgoing";

    public static void registerChatTypes(Registry<ChatType> registry) {
        CHAT = ResourceKey.create((ResourceKey)Registries.CHAT_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"discord_chat_mod", (String)CHAT_PATH));
        Registry.register(registry, CHAT, (Object)CustomChatTypeRegistry.buildChatType(CHAT));
        SAY_COMMAND = ResourceKey.create((ResourceKey)Registries.CHAT_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"discord_chat_mod", (String)SAY_COMMAND_PATH));
        Registry.register(registry, SAY_COMMAND, (Object)CustomChatTypeRegistry.buildChatType(SAY_COMMAND));
        EMOTE_COMMAND = ResourceKey.create((ResourceKey)Registries.CHAT_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"discord_chat_mod", (String)EMOTE_COMMAND_PATH));
        Registry.register(registry, EMOTE_COMMAND, (Object)CustomChatTypeRegistry.buildChatType(EMOTE_COMMAND));
        MSG_COMMAND_INCOMING = ResourceKey.create((ResourceKey)Registries.CHAT_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"discord_chat_mod", (String)MSG_COMMAND_INCOMING_PATH));
        Registry.register(registry, MSG_COMMAND_INCOMING, (Object)CustomChatTypeRegistry.buildChatType(MSG_COMMAND_INCOMING));
        MSG_COMMAND_OUTGOING = ResourceKey.create((ResourceKey)Registries.CHAT_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"discord_chat_mod", (String)MSG_COMMAND_OUTGOING_PATH));
        Registry.register(registry, MSG_COMMAND_OUTGOING, (Object)CustomChatTypeRegistry.buildChatType(MSG_COMMAND_OUTGOING));
        TEAM_MSG_COMMAND_INCOMING = ResourceKey.create((ResourceKey)Registries.CHAT_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"discord_chat_mod", (String)TEAM_MSG_COMMAND_INCOMING_PATH));
        Registry.register(registry, TEAM_MSG_COMMAND_INCOMING, (Object)CustomChatTypeRegistry.buildChatType(TEAM_MSG_COMMAND_INCOMING));
        TEAM_MSG_COMMAND_OUTGOING = ResourceKey.create((ResourceKey)Registries.CHAT_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"discord_chat_mod", (String)TEAM_MSG_COMMAND_OUTGOING_PATH));
        Registry.register(registry, TEAM_MSG_COMMAND_OUTGOING, (Object)CustomChatTypeRegistry.buildChatType(TEAM_MSG_COMMAND_OUTGOING));
    }

    public static String[] getParametersByChatType(ResourceKey<ChatType> chatType) {
        String[] stringArray;
        switch (chatType.location().getPath()) {
            case "chat": 
            case "say_command": 
            case "emote_command": {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "{player}";
                stringArray = stringArray2;
                stringArray2[1] = "{message}";
                break;
            }
            case "msg_command_incoming": {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "{sender}";
                stringArray = stringArray3;
                stringArray3[1] = "{message}";
                break;
            }
            case "msg_command_outgoing": {
                String[] stringArray4 = new String[2];
                stringArray4[0] = "{receiver}";
                stringArray = stringArray4;
                stringArray4[1] = "{message}";
                break;
            }
            case "team_msg_command_incoming": 
            case "team_msg_command_outgoing": {
                String[] stringArray5 = new String[3];
                stringArray5[0] = "{team}";
                stringArray5[1] = "{player}";
                stringArray = stringArray5;
                stringArray5[2] = "{message}";
                break;
            }
            default: {
                stringArray = new String[]{};
            }
        }
        return stringArray;
    }

    public static ChatType.Bound buildBound(ResourceKey<ChatType> chatType, RegistryAccess registryAccess, Component sender, @Nullable Component originalMessage) {
        return new ChatType.Bound((Holder)registryAccess.registryOrThrow(Registries.CHAT_TYPE).getHolderOrThrow(chatType), sender, originalMessage == null ? Optional.empty() : Optional.of(originalMessage));
    }

    private static ChatType buildChatType(ResourceKey<ChatType> key) {
        String narrateTranslationKey = key.location().getPath().equals(EMOTE_COMMAND_PATH) ? "chat.type.emote" : "chat.type.text.narrate";
        List<ChatTypeDecoration.Parameter> chatParameters = List.of(ChatTypeDecoration.Parameter.CONTENT);
        List<ChatTypeDecoration.Parameter> narrationParameters = List.of(ChatTypeDecoration.Parameter.SENDER, ChatTypeDecoration.Parameter.TARGET);
        return new ChatType(new ChatTypeDecoration("%s", chatParameters, Style.EMPTY), new ChatTypeDecoration(narrateTranslationKey, narrationParameters, Style.EMPTY));
    }
}

