/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.chat_style;

import com.denisnumb.discord_chat_mod.DeathMessageUtils;
import com.denisnumb.discord_chat_mod.chat_style.ChatStyleUtils;
import com.denisnumb.discord_chat_mod.chat_style.CustomChatTypeRegistry;
import com.denisnumb.discord_chat_mod.config.ConfigProvider;
import com.denisnumb.discord_chat_mod.config.IConfigProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class MinecraftChatStyleProvider {
    private static Component applyStyleToAdvancement(String translatedTitle, String translatedDescription, Style advancementStyle) {
        MutableComponent title = Component.literal((String)translatedTitle);
        MutableComponent description = ComponentUtils.mergeStyles((MutableComponent)title.copy(), (Style)Style.EMPTY.withColor(advancementStyle.getColor())).append("\n").append((Component)Component.literal((String)translatedDescription));
        MutableComponent result = title.copy().withStyle(arg_0 -> MinecraftChatStyleProvider.lambda$applyStyleToAdvancement$0((Component)description, arg_0));
        return ComponentUtils.wrapInSquareBrackets((Component)result).withStyle(advancementStyle);
    }

    public static Optional<Component> getStyledAdvancementMessage(Player player, AdvancementHolder advancementHolder, String title, String description) {
        String messageStringTemplate;
        IConfigProvider config = ConfigProvider.getConfig();
        DisplayInfo displayInfo = (DisplayInfo)advancementHolder.value().display().get();
        String string = displayInfo.getType() == AdvancementType.TASK ? config.minecraftPlayerAdvancementTaskStyle() : (messageStringTemplate = displayInfo.getType() == AdvancementType.GOAL ? config.minecraftPlayerAdvancementGoalStyle() : config.minecraftPlayerAdvancementChallengeStyle());
        String translationKey = displayInfo.getType() == AdvancementType.TASK ? "chat.type.advancement.task" : (displayInfo.getType() == AdvancementType.GOAL ? "chat.type.advancement.goal" : "chat.type.advancement.challenge");
        MutableComponent template = ChatStyleUtils.parseConfigTemplateMarkdown(ChatStyleUtils.setConfigTemplateTranslatableParameters(messageStringTemplate, translationKey));
        Style advancementStyle = ChatStyleUtils.parseTemplateParameterStyles(template, "{advancement}").get("{advancement}");
        return Optional.of(ChatStyleUtils.applyParametersToTemplate(template, Map.of("{player}", player.getDisplayName(), "{advancement}", MinecraftChatStyleProvider.applyStyleToAdvancement(title, description, advancementStyle))));
    }

    public static Optional<Component> getStyledJoinedLeftMessage(Player player, boolean isJoin) {
        IConfigProvider config = ConfigProvider.getConfig();
        String messageStringTemplate = isJoin ? config.minecraftPlayerJoinedStyle() : config.minecraftPlayerLeftStyle();
        String translationKey = isJoin ? "multiplayer.player.joined" : "multiplayer.player.left";
        return Optional.of(ChatStyleUtils.applyParametersToTemplate(ChatStyleUtils.parseConfigTemplateMarkdown(ChatStyleUtils.setConfigTemplateTranslatableParameters(messageStringTemplate, translationKey)), Map.of("{player}", player.getDisplayName())));
    }

    public static Optional<Component> getStyledChatMessage(ResourceKey<ChatType> chatType, ChatMessageComponents components) {
        Component[] componentArray;
        String configTemplate = ChatStyleUtils.getConfigTemplateByChatType(chatType);
        if (configTemplate == null) {
            return Optional.empty();
        }
        String[] params = CustomChatTypeRegistry.getParametersByChatType(chatType);
        if (params.length == 3) {
            Component[] componentArray2 = new Component[3];
            componentArray2[0] = components.team;
            componentArray2[1] = components.player;
            componentArray = componentArray2;
            componentArray2[2] = components.content;
        } else {
            Component[] componentArray3 = new Component[2];
            componentArray3[0] = components.player;
            componentArray = componentArray3;
            componentArray3[1] = components.content;
        }
        Component[] values2 = componentArray;
        Map<String, Component> parameterToComponent = IntStream.range(0, params.length).boxed().collect(Collectors.toMap(i -> params[i], i -> values2[i]));
        return Optional.of(ChatStyleUtils.applyParametersToTemplate(ChatStyleUtils.parseConfigTemplateMarkdown(configTemplate), parameterToComponent));
    }

    public static Optional<Component> getStyledDeathMessage(DeathMessageUtils.DeathMessageComponents components) {
        IConfigProvider config = ConfigProvider.getConfig();
        String causeStyle = config.minecraftPlayerDeathCauseStyle().replace("{death_cause}", "{death.cause}");
        String nameStyle = config.minecraftPlayerDeathNameStyle().replace("{player}", "{died.entity}");
        String entityStyle = config.minecraftPlayerDeathSecondEntityNameStyle().replace("{second_entity}", "{second.entity}");
        String itemStyle = config.minecraftPlayerDeathWeaponStyle().replace("{item}", "{item}");
        MutableComponent causeTemplate = ChatStyleUtils.parseConfigTemplateMarkdown(causeStyle);
        MutableComponent playerTemplate = ChatStyleUtils.parseConfigTemplateMarkdown(nameStyle);
        MutableComponent entityTemplate = ChatStyleUtils.parseConfigTemplateMarkdown(entityStyle);
        MutableComponent itemTemplate = ChatStyleUtils.parseConfigTemplateMarkdown(itemStyle);
        playerTemplate = ChatStyleUtils.applyParametersToTemplate(playerTemplate.copy(), Map.of("{died.entity}", components.diedEntityName()));
        causeTemplate = ChatStyleUtils.applyParametersToTemplate(causeTemplate.copy(), Map.of("{death.cause}", components.deathCause()));
        if (components.killerEntity() != null) {
            entityTemplate = ChatStyleUtils.applyParametersToTemplate(entityTemplate.copy(), Map.of("{second.entity}", components.killerEntity()));
        }
        if (components.item() != null) {
            itemTemplate = ChatStyleUtils.applyParametersToTemplate(itemTemplate.copy(), Map.of("{item}", components.item()));
        }
        HashMap<String, Component> parameterToDeathMessageComponent = new HashMap<String, Component>();
        parameterToDeathMessageComponent.put("{died.entity}", (Component)playerTemplate);
        parameterToDeathMessageComponent.put("{second.entity}", (Component)(components.killerEntity() != null ? entityTemplate : null));
        parameterToDeathMessageComponent.put("{item}", (Component)(components.item() != null ? itemTemplate : null));
        return Optional.of(ChatStyleUtils.applyParametersToTemplate(causeTemplate.copy(), parameterToDeathMessageComponent));
    }

    private static /* synthetic */ Style lambda$applyStyleToAdvancement$0(Component description, Style style) {
        return style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)description));
    }

    public record ChatMessageComponents(Component player, Component content, @Nullable Component team) {
    }
}

