/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.commands;

import com.denisnumb.discord_chat_mod.DiscordChatMod;
import com.denisnumb.discord_chat_mod.LocaleProvider;
import com.denisnumb.discord_chat_mod.MinecraftUtils;
import com.denisnumb.discord_chat_mod.chat_style.ChatStyleUtils;
import com.denisnumb.discord_chat_mod.discord.ChannelMembersProvider;
import com.denisnumb.discord_chat_mod.discord.DiscordChannelRegistry;
import com.denisnumb.discord_chat_mod.discord.DiscordUtils;
import com.denisnumb.discord_chat_mod.discord.chat_style.DiscordChatStyleProvider;
import com.denisnumb.discord_chat_mod.discord.chat_style.MessageType;
import com.denisnumb.discord_chat_mod.discord.model.ChannelCategory;
import com.denisnumb.discord_chat_mod.discord.model.DiscordUserData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class MentionCommand {
    private static final SuggestionProvider<CommandSourceStack> MENTIONS_PROVIDER = (context, builder) -> {
        if (DiscordChatMod.isDiscordConnected()) {
            String partial = builder.getRemaining().toLowerCase();
            StringRange range = StringRange.between((int)builder.getStart(), (int)builder.getInput().length());
            List<Suggestion> suggestions = ChannelMembersProvider.getMemberData(ChannelCategory.PLAYER_CHAT).stream().filter(data -> MentionCommand.matchesPartial(data, partial)).map(data -> new Suggestion(range, data.getPrettyMention().substring(1))).toList();
            return CompletableFuture.completedFuture(new Suggestions(range, suggestions));
        }
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"mention").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests(MENTIONS_PROVIDER).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            List<DiscordUserData> memberData = ChannelMembersProvider.getMemberData(ChannelCategory.PLAYER_CHAT);
            if (!DiscordChatMod.isDiscordConnected()) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)LocaleProvider.getTranslate("discord_chat_mod.command.send_screenshot.error.discord_not_connected"))).create();
            }
            Optional<DiscordUserData> optionalMemberData = memberData.stream().filter(data -> data.prettyMention.substring(1).equals(name)).findFirst();
            if (optionalMemberData.isEmpty()) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)String.format(LocaleProvider.getTranslate("discord_chat_mod.command.mention.unknown"), name))).create();
            }
            Entity patt0$temp = ((CommandSourceStack)context.getSource()).getEntity();
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                DiscordUserData member = optionalMemberData.get();
                MutableComponent mentionComponent = Component.literal((String)String.format("@%s", name)).withStyle(style -> style.withColor((TextColor)TextColor.parseColor((String)member.color).getOrThrow()).withInsertion("@" + name).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)member.discordName))));
                MinecraftUtils.sendMessageToAllPlayersFromPlayer(Map.of("{player}", player.getDisplayName(), "{message}", mentionComponent));
                Map<String, String> parameters = ChatStyleUtils.mergeMaps(Map.of("{message}", member.mentionString), DiscordChatStyleProvider.buildPlayerParameters((Entity)player));
                Optional<DiscordChatStyleProvider.DiscordMessageComponents> chatComponentsOpt = DiscordChatStyleProvider.getDiscordMessageComponents(MessageType.CHAT, parameters);
                Optional<DiscordChatStyleProvider.DiscordMessageComponents> webhookComponentsOpt = DiscordChatStyleProvider.getDiscordMessageComponents(MessageType.CHAT_WEBHOOK, parameters);
                if (chatComponentsOpt.isPresent() && webhookComponentsOpt.isPresent()) {
                    DiscordUtils.sendMessageFromPlayer(ChannelCategory.PLAYER_CHAT, DiscordChannelRegistry.getAllContexts(), player, webhookComponentsOpt.get(), chatComponentsOpt.get());
                }
            }
            return 1;
        })));
    }

    private static boolean matchesPartial(DiscordUserData member, String partial) {
        return member.displayName.toLowerCase().contains(partial) || member.discordName.toLowerCase().contains(partial);
    }
}

