/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.commands.set_avatar;

import com.denisnumb.discord_chat_mod.LocaleProvider;
import com.denisnumb.discord_chat_mod.chat_images.utils.ImageUtils;
import com.denisnumb.discord_chat_mod.commands.set_avatar.AvatarUrlStorage;
import com.denisnumb.discord_chat_mod.markdown.MarkdownParser;
import com.denisnumb.discord_chat_mod.markdown.MarkdownToComponentConverter;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;

public class SetAvatarCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"set_avatar_url").then(Commands.argument((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String url = StringArgumentType.getString((CommandContext)context, (String)"url");
            if (!ImageUtils.isImageUrl(ImageUtils.getMimeType(url))) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)LocaleProvider.getTranslate("discord_chat_mod.command.set_avatar_url.invalid_url"))).create();
            }
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            if (player == null) {
                return 0;
            }
            AvatarUrlStorage.setUrl(player.getUUID(), url, ((CommandSourceStack)context.getSource()).getServer());
            player.sendSystemMessage((Component)new MarkdownToComponentConverter(MarkdownParser.parseMarkdown(String.format(LocaleProvider.getTranslate("discord_chat_mod.command.set_avatar_url.success"), url))).convertMarkdownTokensToComponent());
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"remove_avatar_url").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            if (player == null) {
                return 0;
            }
            AvatarUrlStorage.removeUrl(player.getUUID(), ((CommandSourceStack)context.getSource()).getServer());
            player.sendSystemMessage((Component)Component.literal((String)LocaleProvider.getTranslate("discord_chat_mod.command.remove_avatar_url.success")).setStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW)));
            return 1;
        }));
    }
}

