/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.commands.vanilla;

import com.denisnumb.discord_chat_mod.MinecraftEvents;
import com.denisnumb.discord_chat_mod.MinecraftUtils;
import com.denisnumb.discord_chat_mod.chat_style.ChatStyleUtils;
import com.denisnumb.discord_chat_mod.chat_style.CustomChatTypeRegistry;
import com.denisnumb.discord_chat_mod.chat_style.MinecraftChatStyleProvider;
import com.denisnumb.discord_chat_mod.discord.DiscordChannelRegistry;
import com.denisnumb.discord_chat_mod.discord.DiscordUtils;
import com.denisnumb.discord_chat_mod.discord.chat_style.DiscordChatStyleProvider;
import com.denisnumb.discord_chat_mod.discord.chat_style.MessageType;
import com.denisnumb.discord_chat_mod.discord.model.ChannelCategory;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;

public class EmoteCommand {
    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"me").then(Commands.argument((String)"action", (ArgumentType)MessageArgument.message()).executes(commandContext -> {
            MessageArgument.resolveChatMessage((CommandContext)commandContext, (String)"action", playerChatMessage -> {
                CommandSourceStack source2 = (CommandSourceStack)commandContext.getSource();
                MinecraftUtils.ProcessChatMessageResult chatMessage = MinecraftUtils.processChatMessage(playerChatMessage.decoratedContent().getString(), ChannelCategory.ME_COMMAND);
                DiscordUtils.handleDiscord(() -> {
                    Map<String, String> parameters = ChatStyleUtils.mergeMaps(Map.of("{message}", chatMessage.forDiscord()), DiscordChatStyleProvider.buildPlayerParameters(source2));
                    Optional<DiscordChatStyleProvider.DiscordMessageComponents> chatComponentsOpt = DiscordChatStyleProvider.getDiscordMessageComponents(MessageType.ME_COMMAND, parameters);
                    Optional<DiscordChatStyleProvider.DiscordMessageComponents> webhookComponentsOpt = DiscordChatStyleProvider.getDiscordMessageComponents(MessageType.ME_COMMAND_WEBHOOK, parameters);
                    if (chatComponentsOpt.isPresent() && webhookComponentsOpt.isPresent()) {
                        DiscordUtils.sendMessageFromPlayer(ChannelCategory.ME_COMMAND, DiscordChannelRegistry.getAllContexts(), (Player)source2.getPlayer(), webhookComponentsOpt.get(), chatComponentsOpt.get());
                    }
                });
                Component senderComponent = source2.getDisplayName();
                Component messageContent = chatMessage.forMinecraft();
                MinecraftEvents.handleChatMessage(CustomChatTypeRegistry.EMOTE_COMMAND, new MinecraftChatStyleProvider.ChatMessageComponents(senderComponent, messageContent, null)).ifPresentOrElse(styledContent -> {
                    ChatType.Bound styledBound = CustomChatTypeRegistry.buildBound(CustomChatTypeRegistry.EMOTE_COMMAND, source2.registryAccess(), senderComponent, messageContent);
                    PlayerChatMessage styledWithMarkdown = playerChatMessage.withUnsignedContent(styledContent);
                    source2.getServer().getPlayerList().broadcastChatMessage(styledWithMarkdown, source2, styledBound);
                }, () -> {
                    PlayerChatMessage withMarkdown = playerChatMessage.withUnsignedContent(messageContent);
                    source2.getServer().getPlayerList().broadcastChatMessage(withMarkdown, source2, ChatType.bind((ResourceKey)ChatType.EMOTE_COMMAND, (CommandSourceStack)source2));
                });
            });
            return 1;
        })));
    }
}

