/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.commands.vanilla;

import com.denisnumb.discord_chat_mod.MinecraftEvents;
import com.denisnumb.discord_chat_mod.MinecraftUtils;
import com.denisnumb.discord_chat_mod.chat_style.CustomChatTypeRegistry;
import com.denisnumb.discord_chat_mod.chat_style.MinecraftChatStyleProvider;
import com.denisnumb.discord_chat_mod.discord.model.ChannelCategory;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;

public class MsgCommand {
    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        LiteralCommandNode literalCommandNode = commandDispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"msg").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"message", (ArgumentType)MessageArgument.message()).executes(commandContext -> {
            Collection collection = EntityArgument.getPlayers((CommandContext)commandContext, (String)"targets");
            if (!collection.isEmpty()) {
                MessageArgument.resolveChatMessage((CommandContext)commandContext, (String)"message", playerChatMessage -> MsgCommand.sendMessage((CommandSourceStack)commandContext.getSource(), collection, playerChatMessage));
            }
            return collection.size();
        }))));
        commandDispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"tell").redirect((CommandNode)literalCommandNode));
        commandDispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"w").redirect((CommandNode)literalCommandNode));
    }

    private static void sendMessage(CommandSourceStack commandSourceStack, Collection<ServerPlayer> collection, PlayerChatMessage playerChatMessage) {
        MinecraftUtils.ProcessChatMessageResult chatMessage = MinecraftUtils.processChatMessage(playerChatMessage.decoratedContent().getString(), ChannelCategory.PLAYER_CHAT);
        PlayerChatMessage playerChatMessageStyled = playerChatMessage.withUnsignedContent(chatMessage.forMinecraft());
        MinecraftEvents.handleChatMessage(CustomChatTypeRegistry.MSG_COMMAND_INCOMING, new MinecraftChatStyleProvider.ChatMessageComponents(commandSourceStack.getDisplayName(), playerChatMessageStyled.decoratedContent(), null)).ifPresentOrElse(styledContent -> MsgCommand.sendMessageStyled(commandSourceStack, collection, playerChatMessageStyled, styledContent), () -> MsgCommand.sendMessageDefault(commandSourceStack, collection, playerChatMessageStyled));
    }

    private static void sendMessageStyled(CommandSourceStack commandSourceStack, Collection<ServerPlayer> collection, PlayerChatMessage playerChatMessage, Component styledIncomingContent) {
        ChatType.Bound styledIncoming = CustomChatTypeRegistry.buildBound(CustomChatTypeRegistry.MSG_COMMAND_INCOMING, commandSourceStack.registryAccess(), commandSourceStack.getDisplayName(), playerChatMessage.decoratedContent());
        OutgoingChatMessage incomingChatMessage = OutgoingChatMessage.create((PlayerChatMessage)playerChatMessage.withUnsignedContent(styledIncomingContent));
        boolean bl = false;
        for (ServerPlayer serverPlayer : collection) {
            Optional<Component> styledOutgoingContentOptional = MinecraftEvents.handleChatMessage(CustomChatTypeRegistry.MSG_COMMAND_OUTGOING, new MinecraftChatStyleProvider.ChatMessageComponents(serverPlayer.getDisplayName(), playerChatMessage.decoratedContent(), null));
            if (!styledOutgoingContentOptional.isPresent()) continue;
            ChatType.Bound styledOutgoing = CustomChatTypeRegistry.buildBound(CustomChatTypeRegistry.MSG_COMMAND_OUTGOING, commandSourceStack.registryAccess(), serverPlayer.getDisplayName(), playerChatMessage.decoratedContent());
            OutgoingChatMessage outgoingChatMessage = OutgoingChatMessage.create((PlayerChatMessage)playerChatMessage.withUnsignedContent(styledOutgoingContentOptional.get()));
            commandSourceStack.sendChatMessage(outgoingChatMessage, false, styledOutgoing);
            boolean bl2 = commandSourceStack.shouldFilterMessageTo(serverPlayer);
            serverPlayer.sendChatMessage(incomingChatMessage, bl2, styledIncoming);
            bl |= bl2 && playerChatMessage.isFullyFiltered();
        }
        if (bl) {
            commandSourceStack.sendSystemMessage(PlayerList.CHAT_FILTERED_FULL);
        }
    }

    private static void sendMessageDefault(CommandSourceStack commandSourceStack, Collection<ServerPlayer> collection, PlayerChatMessage playerChatMessage) {
        ChatType.Bound bound = ChatType.bind((ResourceKey)ChatType.MSG_COMMAND_INCOMING, (CommandSourceStack)commandSourceStack);
        OutgoingChatMessage outgoingChatMessage = OutgoingChatMessage.create((PlayerChatMessage)playerChatMessage);
        boolean bl = false;
        for (ServerPlayer serverPlayer : collection) {
            ChatType.Bound bound2 = ChatType.bind((ResourceKey)ChatType.MSG_COMMAND_OUTGOING, (CommandSourceStack)commandSourceStack).withTargetName(serverPlayer.getDisplayName());
            commandSourceStack.sendChatMessage(outgoingChatMessage, false, bound2);
            boolean bl2 = commandSourceStack.shouldFilterMessageTo(serverPlayer);
            serverPlayer.sendChatMessage(outgoingChatMessage, bl2, bound);
            bl |= bl2 && playerChatMessage.isFullyFiltered();
        }
        if (bl) {
            commandSourceStack.sendSystemMessage(PlayerList.CHAT_FILTERED_FULL);
        }
    }
}

