/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.commands.vanilla;

import com.denisnumb.discord_chat_mod.MinecraftEvents;
import com.denisnumb.discord_chat_mod.MinecraftUtils;
import com.denisnumb.discord_chat_mod.chat_style.ChatStyleUtils;
import com.denisnumb.discord_chat_mod.chat_style.CustomChatTypeRegistry;
import com.denisnumb.discord_chat_mod.chat_style.MinecraftChatStyleProvider;
import com.denisnumb.discord_chat_mod.discord.DiscordChannelRegistry;
import com.denisnumb.discord_chat_mod.discord.DiscordUtils;
import com.denisnumb.discord_chat_mod.discord.chat_style.DiscordChatStyleProvider;
import com.denisnumb.discord_chat_mod.discord.chat_style.MessageType;
import com.denisnumb.discord_chat_mod.discord.model.ChannelCategory;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.resources.ResourceKey;

public class SayCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"say").requires(source2 -> source2.hasPermission(2))).then(Commands.argument((String)"message", (ArgumentType)MessageArgument.message()).executes(context -> {
            MessageArgument.resolveChatMessage((CommandContext)context, (String)"message", resolvedMessage -> {
                CommandSourceStack source2 = (CommandSourceStack)context.getSource();
                MinecraftUtils.ProcessChatMessageResult chatMessage = MinecraftUtils.processChatMessage(resolvedMessage.decoratedContent().getString(), ChannelCategory.SAY_COMMAND);
                DiscordUtils.handleDiscord(() -> {
                    Map<String, String> parameters = ChatStyleUtils.mergeMaps(Map.of("{message}", chatMessage.forDiscord()), DiscordChatStyleProvider.buildPlayerParameters(source2));
                    DiscordChatStyleProvider.getDiscordMessageComponents(MessageType.SAY_COMMAND, parameters).ifPresent(components -> DiscordUtils.sendMessageFromServer(ChannelCategory.SAY_COMMAND, DiscordChannelRegistry.getAllContexts(), components));
                });
                Component senderComponent = source2.getDisplayName();
                Component messageContent = chatMessage.forMinecraft();
                MinecraftEvents.handleChatMessage(CustomChatTypeRegistry.SAY_COMMAND, new MinecraftChatStyleProvider.ChatMessageComponents(senderComponent, messageContent, null)).ifPresentOrElse(styledContent -> {
                    ChatType.Bound styledBound = CustomChatTypeRegistry.buildBound(CustomChatTypeRegistry.SAY_COMMAND, source2.registryAccess(), senderComponent, messageContent);
                    PlayerChatMessage styledWithMarkdown = resolvedMessage.withUnsignedContent(styledContent);
                    source2.getServer().getPlayerList().broadcastChatMessage(styledWithMarkdown, source2, styledBound);
                }, () -> {
                    PlayerChatMessage withMarkdown = resolvedMessage.withUnsignedContent(messageContent);
                    source2.getServer().getPlayerList().broadcastChatMessage(withMarkdown, source2, ChatType.bind((ResourceKey)ChatType.SAY_COMMAND, (CommandSourceStack)source2));
                });
            });
            return 1;
        })));
    }
}

