/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.commands.vanilla;

import com.denisnumb.discord_chat_mod.MinecraftEvents;
import com.denisnumb.discord_chat_mod.MinecraftUtils;
import com.denisnumb.discord_chat_mod.chat_style.CustomChatTypeRegistry;
import com.denisnumb.discord_chat_mod.chat_style.MinecraftChatStyleProvider;
import com.denisnumb.discord_chat_mod.discord.model.ChannelCategory;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.PlayerTeam;

public class TeamMsgCommand {
    private static final Style SUGGEST_STYLE = Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"chat.type.team.hover"))).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/teammsg "));
    private static final SimpleCommandExceptionType ERROR_NOT_ON_TEAM = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.teammsg.failed.noteam"));

    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        LiteralCommandNode literalCommandNode = commandDispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"teammsg").then(Commands.argument((String)"message", (ArgumentType)MessageArgument.message()).executes(commandContext -> {
            CommandSourceStack commandSourceStack = (CommandSourceStack)commandContext.getSource();
            Entity entity = commandSourceStack.getEntityOrException();
            PlayerTeam playerTeam = entity.getTeam();
            if (playerTeam == null) {
                throw ERROR_NOT_ON_TEAM.create();
            }
            List<ServerPlayer> list = commandSourceStack.getServer().getPlayerList().getPlayers().stream().filter(serverPlayer -> serverPlayer == entity || serverPlayer.getTeam() == playerTeam).toList();
            if (!list.isEmpty()) {
                MessageArgument.resolveChatMessage((CommandContext)commandContext, (String)"message", playerChatMessage -> TeamMsgCommand.sendMessage(commandSourceStack, entity, playerTeam, list, playerChatMessage));
            }
            return list.size();
        })));
        commandDispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"tm").redirect((CommandNode)literalCommandNode));
    }

    private static void sendMessage(CommandSourceStack commandSourceStack, Entity entity, PlayerTeam playerTeam, List<ServerPlayer> list, PlayerChatMessage playerChatMessage) {
        MinecraftUtils.ProcessChatMessageResult chatMessage = MinecraftUtils.processChatMessage(playerChatMessage.decoratedContent().getString(), ChannelCategory.PLAYER_CHAT);
        PlayerChatMessage playerChatMessageStyled = playerChatMessage.withUnsignedContent(chatMessage.forMinecraft());
        MinecraftEvents.handleChatMessage(CustomChatTypeRegistry.TEAM_MSG_COMMAND_INCOMING, new MinecraftChatStyleProvider.ChatMessageComponents(commandSourceStack.getDisplayName(), playerChatMessageStyled.decoratedContent(), (Component)playerTeam.getFormattedDisplayName().withStyle(SUGGEST_STYLE))).ifPresentOrElse(styledContent -> TeamMsgCommand.sendMessageStyled(commandSourceStack, entity, playerTeam, list, playerChatMessageStyled, styledContent), () -> TeamMsgCommand.sendMessageDefault(commandSourceStack, entity, playerTeam, list, playerChatMessageStyled));
    }

    private static void sendMessageStyled(CommandSourceStack commandSourceStack, Entity entity, PlayerTeam playerTeam, List<ServerPlayer> list, PlayerChatMessage playerChatMessage, Component styledIncomingContent) {
        Optional<Component> styledOutgoungContentOptional = MinecraftEvents.handleChatMessage(CustomChatTypeRegistry.TEAM_MSG_COMMAND_OUTGOING, new MinecraftChatStyleProvider.ChatMessageComponents(commandSourceStack.getDisplayName(), playerChatMessage.decoratedContent(), (Component)playerTeam.getFormattedDisplayName().withStyle(SUGGEST_STYLE)));
        if (styledOutgoungContentOptional.isPresent()) {
            ChatType.Bound styledIncoming = CustomChatTypeRegistry.buildBound(CustomChatTypeRegistry.TEAM_MSG_COMMAND_INCOMING, commandSourceStack.registryAccess(), commandSourceStack.getDisplayName(), playerChatMessage.decoratedContent());
            ChatType.Bound styledOutgoing = CustomChatTypeRegistry.buildBound(CustomChatTypeRegistry.TEAM_MSG_COMMAND_OUTGOING, commandSourceStack.registryAccess(), commandSourceStack.getDisplayName(), playerChatMessage.decoratedContent());
            OutgoingChatMessage incomingChatMessage = OutgoingChatMessage.create((PlayerChatMessage)playerChatMessage.withUnsignedContent(styledIncomingContent));
            OutgoingChatMessage outgoingChatMessage = OutgoingChatMessage.create((PlayerChatMessage)playerChatMessage.withUnsignedContent(styledOutgoungContentOptional.get()));
            boolean bl = false;
            for (ServerPlayer serverPlayer : list) {
                ChatType.Bound bound = serverPlayer == entity ? styledOutgoing : styledIncoming;
                OutgoingChatMessage message = serverPlayer == entity ? outgoingChatMessage : incomingChatMessage;
                boolean bl2 = commandSourceStack.shouldFilterMessageTo(serverPlayer);
                serverPlayer.sendChatMessage(message, bl2, bound);
                bl |= bl2 && playerChatMessage.isFullyFiltered();
            }
            if (bl) {
                commandSourceStack.sendSystemMessage(PlayerList.CHAT_FILTERED_FULL);
            }
        }
    }

    private static void sendMessageDefault(CommandSourceStack commandSourceStack, Entity entity, PlayerTeam playerTeam, List<ServerPlayer> list, PlayerChatMessage playerChatMessage) {
        MutableComponent component = playerTeam.getFormattedDisplayName().withStyle(SUGGEST_STYLE);
        ChatType.Bound bound = ChatType.bind((ResourceKey)ChatType.TEAM_MSG_COMMAND_INCOMING, (CommandSourceStack)commandSourceStack).withTargetName((Component)component);
        ChatType.Bound bound2 = ChatType.bind((ResourceKey)ChatType.TEAM_MSG_COMMAND_OUTGOING, (CommandSourceStack)commandSourceStack).withTargetName((Component)component);
        OutgoingChatMessage outgoingChatMessage = OutgoingChatMessage.create((PlayerChatMessage)playerChatMessage);
        boolean bl = false;
        for (ServerPlayer serverPlayer : list) {
            ChatType.Bound bound3 = serverPlayer == entity ? bound2 : bound;
            boolean bl2 = commandSourceStack.shouldFilterMessageTo(serverPlayer);
            serverPlayer.sendChatMessage(outgoingChatMessage, bl2, bound3);
            bl |= bl2 && playerChatMessage.isFullyFiltered();
        }
        if (bl) {
            commandSourceStack.sendSystemMessage(PlayerList.CHAT_FILTERED_FULL);
        }
    }
}

