/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.commands.vanilla;

import com.denisnumb.discord_chat_mod.MinecraftUtils;
import com.denisnumb.discord_chat_mod.discord.DiscordChannelRegistry;
import com.denisnumb.discord_chat_mod.discord.DiscordUtils;
import com.denisnumb.discord_chat_mod.discord.chat_style.DiscordChatStyleProvider;
import com.denisnumb.discord_chat_mod.discord.chat_style.MessageType;
import com.denisnumb.discord_chat_mod.discord.model.ChannelCategory;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class TellrawCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tellraw").requires(source2 -> source2.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"message", (ArgumentType)ComponentArgument.textComponent((CommandBuildContext)context)).executes(ctx -> {
            Collection players = EntityArgument.getPlayers((CommandContext)ctx, (String)"targets");
            Component message = ComponentArgument.getComponent((CommandContext)ctx, (String)"message");
            if (ctx.getInput().split(" ", 3)[1].equals("@a")) {
                DiscordUtils.handleDiscord(() -> {
                    StringBuilder messageTextBuilder = new StringBuilder();
                    messageTextBuilder.append(TellrawCommand.parseComponentContents(message.getContents(), message.getStyle()));
                    for (Component comp : message.getSiblings()) {
                        messageTextBuilder.append(TellrawCommand.parseComponentContents(comp.getContents(), comp.getStyle()));
                    }
                    DiscordChatStyleProvider.getDiscordMessageComponents(MessageType.TELLRAW_COMMAND, Map.of("{message}", DiscordUtils.replaceEmojiCodesToDiscordMentions(messageTextBuilder.toString()))).ifPresent(components -> DiscordUtils.sendMessageFromServer(ChannelCategory.TELLRAW_COMMAND, DiscordChannelRegistry.getAllContexts(), components));
                });
            }
            for (ServerPlayer player : players) {
                player.sendSystemMessage((Component)ComponentUtils.updateForEntity((CommandSourceStack)((CommandSourceStack)ctx.getSource()), (Component)message, (Entity)player, (int)0), false);
            }
            return players.size();
        }))));
    }

    private static String parseComponentContents(ComponentContents componentContents, Style style) {
        try {
            MutableComponent component = componentContents.resolve(null, null, 0);
            if (componentContents instanceof SelectorContents) {
                SelectorContents selectorContents = (SelectorContents)componentContents;
                List<ServerPlayer> playerList = MinecraftUtils.getPlayerListBySelector(selectorContents.getPattern());
                String result = component.getString();
                if (!playerList.isEmpty()) {
                    result = String.join((CharSequence)", ", playerList.stream().map(p -> p.getDisplayName().getString()).toList());
                }
                return TellrawCommand.applyStyles(style, result);
            }
            return TellrawCommand.applyStyles(style, component.getString());
        }
        catch (CommandSyntaxException e) {
            return "";
        }
    }

    private static String applyStyles(Style style, String translatedText) {
        if (style.isBold()) {
            translatedText = "**" + (String)translatedText + "**";
        }
        if (style.isItalic()) {
            translatedText = "*" + (String)translatedText + "*";
        }
        if (style.isStrikethrough()) {
            translatedText = "~~" + (String)translatedText + "~~";
        }
        if (style.isUnderlined()) {
            translatedText = "__" + (String)translatedText + "__";
        }
        if (style.isObfuscated()) {
            translatedText = "||" + (String)translatedText + "||";
        }
        return translatedText;
    }
}

