/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.config;

import com.denisnumb.discord_chat_mod.config.configs.ClientConfig;
import com.denisnumb.discord_chat_mod.config.configs.CommonConfig;
import com.denisnumb.discord_chat_mod.config.configs.DiscordChatStyleConfig;
import com.denisnumb.discord_chat_mod.config.configs.DiscordGuildsConfig;
import com.denisnumb.discord_chat_mod.config.configs.DiscordProxyConfig;
import com.denisnumb.discord_chat_mod.config.configs.MinecraftChatStyleConfig;
import com.denisnumb.discord_chat_mod.config.configs.WebhookModeConfig;
import com.shadow.com.electronwill.nightconfig.core.CommentedConfig;
import com.shadow.com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.Nullable;

public class ConfigManager {
    private static final String CONFIG_DIR_NAME = "config";
    private static final String COMMON_PATH = "discord_chat_mod-common.toml";
    private static final String CLIENT_PATH = "discord_chat_mod-client.toml";

    public static void load(boolean loadClient) {
        ConfigManager.loadCommon();
        if (loadClient) {
            ConfigManager.loadClient();
        }
    }

    @Nullable
    private static Path getConfigFile(String fileName) {
        Path configDir = Paths.get(CONFIG_DIR_NAME, new String[0]);
        if (!Files.exists(configDir, new LinkOption[0])) {
            try {
                Files.createDirectories(configDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                return null;
            }
        }
        return configDir.resolve(fileName);
    }

    private static void removeDeprecatedParameters(CommentedConfig config) {
        config.remove("discordChannelId");
        config.remove("channelOverrides");
        config.remove("enablePinnedStatusMessage");
    }

    private static void loadCommon() {
        CommentedFileConfig commonConfig = (CommentedFileConfig)CommentedFileConfig.builder(ConfigManager.getConfigFile(COMMON_PATH)).autosave().preserveInsertionOrder().sync().build();
        commonConfig.load();
        ConfigManager.removeDeprecatedParameters(commonConfig);
        CommonConfig.loadCommonConfig(commonConfig);
        commonConfig.set("guilds", DiscordGuildsConfig.loadDiscordGuildsConfig(commonConfig));
        commonConfig.set("webhookModeConfig", (Object)WebhookModeConfig.loadWebhookModeConfig(commonConfig));
        commonConfig.set("discordProxyConfig", (Object)DiscordProxyConfig.loadDiscordProxyConfig(commonConfig));
        commonConfig.set("minecraftChatStyle", (Object)MinecraftChatStyleConfig.loadMinecraftChatStyleConfig(commonConfig));
        commonConfig.set("discordChatStyle", (Object)DiscordChatStyleConfig.loadDiscordChatStyleConfig(commonConfig));
        commonConfig.save();
    }

    private static void loadClient() {
        CommentedFileConfig clientConfig = (CommentedFileConfig)CommentedFileConfig.builder(ConfigManager.getConfigFile(CLIENT_PATH)).autosave().preserveInsertionOrder().sync().build();
        clientConfig.load();
        ClientConfig.loadClientConfig(clientConfig);
        clientConfig.save();
    }
}

