/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.config.configs;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.logging.LogUtils;
import com.shadow.com.electronwill.nightconfig.core.CommentedConfig;
import org.slf4j.Logger;

public class DiscordChatStyleConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new Gson();
    public static String discordPlayerMessageStyle;
    public static String discordPlayerMessageWebhookStyle;
    public static String discordPlayerJoinedStyle;
    public static String discordPlayerLeftStyle;
    public static String discordPlayerDeathCauseStyle;
    public static String discordPlayerDeathNameStyle;
    public static String discordPlayerDeathSecondEntityStyle;
    public static String discordPlayerDeathWeaponStyle;
    public static String discordPlayerDeathMessageStyle;
    public static String discordPlayerAdvancementTaskStyle;
    public static String discordPlayerAdvancementGoalStyle;
    public static String discordPlayerAdvancementChallengeStyle;
    public static String discordSayCommandStyle;
    public static String discordMeCommandStyle;
    public static String discordMeCommandWebhookStyle;
    public static String discordTellrawCommandStyle;
    public static String discordScreenshotMessageStyle;
    public static String discordScreenshotMessageWebhookStyle;
    public static String discordServerStartedMessageStyle;
    public static String discordLocalServerStartedMessageStyle;
    public static String discordServerClosedMessageStyle;
    public static String discordPinnedStatusMessageServerUnavailableStyle;
    public static String discordPinnedStatusMessageServerAvailableStyle;
    public static String discordPinnedStatusMessagePlayerListDelimiter;
    public static String discordPinnedStatusMessagePlayerListNicknameStyle;
    public static String discordPinnedStatusMessageStyle;
    public static String discordGuildForwardedMessageUserNameStyle;

    public static CommentedConfig loadDiscordChatStyleConfig(CommentedConfig commonConfig) {
        CommentedConfig existedDiscordChatStyle = commonConfig.getOrElse("discordChatStyle", commonConfig.createSubConfig());
        CommentedConfig discordChatStyle = commonConfig.createSubConfig();
        discordPlayerMessageStyle = existedDiscordChatStyle.getOrElse("discordPlayerMessageStyle", "{\n    \"content\": \"`<{player}>` {message}\"\n}\n");
        discordChatStyle.set("discordPlayerMessageStyle", (Object)discordPlayerMessageStyle.replace("\r", ""));
        discordChatStyle.setComment("discordPlayerMessageStyle", " The configuration settings below determine how messages sent from Minecraft to Discord will be formatted.\n The message format is specified in JSON format. You can remove the parameter from the configuration to get the default value\n For each format, you can use dynamic parameters specified in the comment above the parameter.\n Global parameters available for all styles listed below:\n {player_avatar_url} \u2014 link to the player's avatar (available wherever the {player} parameter is present)\n {timestamp} \u2014 current number of seconds in the system. It's convenient to substitute when using Discord timestamps, for example: <t:{timestamp}:R>\n {datetime} \u2014 A string with the current date and time in the format \"2025-11-02T10:00:00.000Z\". May be useful for embed timestamps.\n You can read more about this configuration section and see examples here: https://github.com/denisnumb/discord-chat-mod/wiki/Discord-Chat-Customization\n \n Chat message from player\n Parameters: {player}, {message}");
        discordPlayerMessageStyle = DiscordChatStyleConfig.validateJsonValue(discordPlayerMessageStyle, "{\n    \"content\": \"`<{player}>` {message}\"\n}\n");
        discordPlayerMessageWebhookStyle = existedDiscordChatStyle.getOrElse("discordPlayerMessageWebhookStyle", "{\n    \"content\": \"{message}\"\n}\n");
        discordChatStyle.set("discordPlayerMessageWebhookStyle", (Object)discordPlayerMessageWebhookStyle.replace("\r", ""));
        discordChatStyle.setComment("discordPlayerMessageWebhookStyle", " Chat message from player (if webhook mode is enabled) \n Parameters: {player}, {message}");
        discordPlayerMessageWebhookStyle = DiscordChatStyleConfig.validateJsonValue(discordPlayerMessageWebhookStyle, "{\n    \"content\": \"{message}\"\n}\n");
        discordPlayerJoinedStyle = existedDiscordChatStyle.getOrElse("discordPlayerJoinedStyle", "{\n    \"embed\": {\n        \"author\": {\n            \"name\": \"{player} {multiplayer.player.joined}\",\n            \"icon_url\": \"{player_avatar_url}\"\n        },\n        \"color\": \"#2ECC71\"\n    }\n}\n");
        discordChatStyle.set("discordPlayerJoinedStyle", (Object)discordPlayerJoinedStyle.replace("\r", ""));
        discordChatStyle.setComment("discordPlayerJoinedStyle", " Player joined the game\n Parameters: {player}, {multiplayer.player.joined}");
        discordPlayerJoinedStyle = DiscordChatStyleConfig.validateJsonValue(discordPlayerJoinedStyle, "{\n    \"embed\": {\n        \"author\": {\n            \"name\": \"{player} {multiplayer.player.joined}\",\n            \"icon_url\": \"{player_avatar_url}\"\n        },\n        \"color\": \"#2ECC71\"\n    }\n}\n");
        discordPlayerLeftStyle = existedDiscordChatStyle.getOrElse("discordPlayerLeftStyle", "{\n    \"embed\": {\n        \"author\": {\n            \"name\": \"{player} {multiplayer.player.left}\",\n            \"icon_url\": \"{player_avatar_url}\"\n        },\n        \"color\": \"#E74C3C\"\n    }\n}\n");
        discordChatStyle.set("discordPlayerLeftStyle", (Object)discordPlayerLeftStyle.replace("\r", ""));
        discordChatStyle.setComment("discordPlayerLeftStyle", " Player left the game\n Parameters: {player}, {multiplayer.player.left}");
        discordPlayerLeftStyle = DiscordChatStyleConfig.validateJsonValue(discordPlayerLeftStyle, "{\n    \"embed\": {\n        \"author\": {\n            \"name\": \"{player} {multiplayer.player.left}\",\n            \"icon_url\": \"{player_avatar_url}\"\n        },\n        \"color\": \"#E74C3C\"\n    }\n}\n");
        discordPlayerDeathCauseStyle = existedDiscordChatStyle.getOrElse("discordPlayerDeathCauseStyle", "{death_cause}");
        discordChatStyle.set("discordPlayerDeathCauseStyle", (Object)discordPlayerDeathCauseStyle);
        discordChatStyle.setComment("discordPlayerDeathCauseStyle", " You can apply Markdown to individual components of the death message using the parameters below.\n They will ultimately be compiled into the {death_message} substitution parameter, which you can use to form the final message in Discord.");
        discordPlayerDeathNameStyle = existedDiscordChatStyle.getOrElse("discordPlayerDeathNameStyle", "{player}");
        discordChatStyle.set("discordPlayerDeathNameStyle", (Object)discordPlayerDeathNameStyle);
        discordPlayerDeathSecondEntityStyle = existedDiscordChatStyle.getOrElse("discordPlayerDeathSecondEntityStyle", "{second_entity}");
        discordChatStyle.set("discordPlayerDeathSecondEntityStyle", (Object)discordPlayerDeathSecondEntityStyle);
        discordPlayerDeathWeaponStyle = existedDiscordChatStyle.getOrElse("discordPlayerDeathWeaponStyle", "{item}");
        discordChatStyle.set("discordPlayerDeathWeaponStyle", (Object)discordPlayerDeathWeaponStyle);
        discordPlayerDeathMessageStyle = existedDiscordChatStyle.getOrElse("discordPlayerDeathMessageStyle", "{\n    \"embed\": {\n        \"author\": {\n            \"name\": \"{death_message}\",\n            \"icon_url\": \"{player_avatar_url}\"\n        }\n    }\n}\n");
        discordChatStyle.set("discordPlayerDeathMessageStyle", (Object)discordPlayerDeathMessageStyle.replace("\r", ""));
        discordChatStyle.setComment("discordPlayerDeathMessageStyle", " Player death message (configure parameters above)\n Parameters: {player}, {death_message}");
        discordPlayerDeathMessageStyle = DiscordChatStyleConfig.validateJsonValue(discordPlayerDeathMessageStyle, "{\n    \"embed\": {\n        \"author\": {\n            \"name\": \"{death_message}\",\n            \"icon_url\": \"{player_avatar_url}\"\n        }\n    }\n}\n");
        discordPlayerAdvancementTaskStyle = existedDiscordChatStyle.getOrElse("discordPlayerAdvancementTaskStyle", "{\n    \"embed\": {\n        \"title\": \"**{advancement}**\",\n        \"description\": \"{description}\",\n        \"color\": \"#F1C40F\",\n        \"author\": {\n            \"name\": \"{player} {chat.type.advancement.task}\",\n            \"icon_url\": \"{player_avatar_url}\"\n        },\n        \"thumbnail\": {\n            \"url\": \"{icon_url}\"\n        }\n    }\n}\n");
        discordChatStyle.set("discordPlayerAdvancementTaskStyle", (Object)discordPlayerAdvancementTaskStyle.replace("\r", ""));
        discordChatStyle.setComment("discordPlayerAdvancementTaskStyle", " Player has made the advancement\n Parameters: {player}, {chat.type.advancement.task}, {advancement}, {description}, {icon_url}");
        discordPlayerAdvancementTaskStyle = DiscordChatStyleConfig.validateJsonValue(discordPlayerAdvancementTaskStyle, "{\n    \"embed\": {\n        \"title\": \"**{advancement}**\",\n        \"description\": \"{description}\",\n        \"color\": \"#F1C40F\",\n        \"author\": {\n            \"name\": \"{player} {chat.type.advancement.task}\",\n            \"icon_url\": \"{player_avatar_url}\"\n        },\n        \"thumbnail\": {\n            \"url\": \"{icon_url}\"\n        }\n    }\n}\n");
        discordPlayerAdvancementGoalStyle = existedDiscordChatStyle.getOrElse("discordPlayerAdvancementGoalStyle", "{\n    \"embed\": {\n        \"title\": \"**{advancement}**\",\n        \"description\": \"{description}\",\n        \"color\": \"#F1C40F\",\n        \"author\": {\n            \"name\": \"{player} {chat.type.advancement.goal}\",\n            \"icon_url\": \"{player_avatar_url}\"\n        },\n        \"thumbnail\": {\n            \"url\": \"{icon_url}\"\n        }\n    }\n}\n");
        discordChatStyle.set("discordPlayerAdvancementGoalStyle", (Object)discordPlayerAdvancementGoalStyle.replace("\r", ""));
        discordChatStyle.setComment("discordPlayerAdvancementGoalStyle", " Player has reached the goal\n Parameters: {player}, {chat.type.advancement.goal}, {advancement}, {description}, {icon_url}");
        discordPlayerAdvancementGoalStyle = DiscordChatStyleConfig.validateJsonValue(discordPlayerAdvancementGoalStyle, "{\n    \"embed\": {\n        \"title\": \"**{advancement}**\",\n        \"description\": \"{description}\",\n        \"color\": \"#F1C40F\",\n        \"author\": {\n            \"name\": \"{player} {chat.type.advancement.goal}\",\n            \"icon_url\": \"{player_avatar_url}\"\n        },\n        \"thumbnail\": {\n            \"url\": \"{icon_url}\"\n        }\n    }\n}\n");
        discordPlayerAdvancementChallengeStyle = existedDiscordChatStyle.getOrElse("discordPlayerAdvancementChallengeStyle", "{\n    \"embed\": {\n        \"title\": \"**{advancement}**\",\n        \"description\": \"{description}\",\n        \"color\": \"#A700A7\",\n        \"author\": {\n            \"name\": \"{player} {chat.type.advancement.challenge}\",\n            \"icon_url\": \"{player_avatar_url}\"\n        },\n        \"thumbnail\": {\n            \"url\": \"{icon_url}\"\n        }\n    }\n}\n");
        discordChatStyle.set("discordPlayerAdvancementChallengeStyle", (Object)discordPlayerAdvancementChallengeStyle.replace("\r", ""));
        discordChatStyle.setComment("discordPlayerAdvancementChallengeStyle", " Player has completed the challenge\n Parameters: {player}, {chat.type.advancement.challenge}, {advancement}, {description}, {icon_url}");
        discordPlayerAdvancementChallengeStyle = DiscordChatStyleConfig.validateJsonValue(discordPlayerAdvancementChallengeStyle, "{\n    \"embed\": {\n        \"title\": \"**{advancement}**\",\n        \"description\": \"{description}\",\n        \"color\": \"#A700A7\",\n        \"author\": {\n            \"name\": \"{player} {chat.type.advancement.challenge}\",\n            \"icon_url\": \"{player_avatar_url}\"\n        },\n        \"thumbnail\": {\n            \"url\": \"{icon_url}\"\n        }\n    }\n}\n");
        discordSayCommandStyle = existedDiscordChatStyle.getOrElse("discordSayCommandStyle", "{\n    \"content\": \"`[{player}]` {message}\"\n}\n");
        discordChatStyle.set("discordSayCommandStyle", (Object)discordSayCommandStyle.replace("\r", ""));
        discordChatStyle.setComment("discordSayCommandStyle", " Chat message from player sent using /say command\n Parameters: {player}, {message}");
        discordSayCommandStyle = DiscordChatStyleConfig.validateJsonValue(discordSayCommandStyle, "{\n    \"content\": \"`[{player}]` {message}\"\n}\n");
        discordMeCommandStyle = existedDiscordChatStyle.getOrElse("discordMeCommandStyle", "{\n    \"content\": \"* {player} {message}\"\n}\n");
        discordChatStyle.set("discordMeCommandStyle", (Object)discordMeCommandStyle.replace("\r", ""));
        discordChatStyle.setComment("discordMeCommandStyle", " Chat message from player sent using /me command\n Parameters: {player}, {message}");
        discordMeCommandStyle = DiscordChatStyleConfig.validateJsonValue(discordMeCommandStyle, "{\n    \"content\": \"* {player} {message}\"\n}\n");
        discordMeCommandWebhookStyle = existedDiscordChatStyle.getOrElse("discordMeCommandWebhookStyle", "{\n    \"content\": \"> {message}\"\n}\n");
        discordChatStyle.set("discordMeCommandWebhookStyle", (Object)discordMeCommandWebhookStyle.replace("\r", ""));
        discordChatStyle.setComment("discordMeCommandWebhookStyle", " Chat message from player sent using /me command (if webhook mode is enabled)\n Parameters: {player}, {message}");
        discordMeCommandWebhookStyle = DiscordChatStyleConfig.validateJsonValue(discordMeCommandWebhookStyle, "{\n    \"content\": \"> {message}\"\n}\n");
        discordTellrawCommandStyle = existedDiscordChatStyle.getOrElse("discordTellrawCommandStyle", "{\n    \"content\": \"{message}\"\n}\n");
        discordChatStyle.set("discordTellrawCommandStyle", (Object)discordTellrawCommandStyle.replace("\r", ""));
        discordChatStyle.setComment("discordTellrawCommandStyle", " Chat message from send using /tellraw @a command\n Parameters: {message}");
        discordTellrawCommandStyle = DiscordChatStyleConfig.validateJsonValue(discordTellrawCommandStyle, "{\n    \"content\": \"{message}\"\n}\n");
        discordScreenshotMessageStyle = existedDiscordChatStyle.getOrElse("discordScreenshotMessageStyle", "{\n    \"content\": \"`<{player}>`\"\n}\n");
        discordChatStyle.set("discordScreenshotMessageStyle", (Object)discordScreenshotMessageStyle.replace("\r", ""));
        discordChatStyle.setComment("discordScreenshotMessageStyle", " Screenshot from player\n Parameters: {player}, {screenshot_url}");
        discordScreenshotMessageStyle = DiscordChatStyleConfig.validateJsonValue(discordScreenshotMessageStyle, "{\n    \"content\": \"`<{player}>`\"\n}\n");
        discordScreenshotMessageWebhookStyle = existedDiscordChatStyle.getOrElse("discordScreenshotMessageWebhookStyle", "{\n    \"content\": \"\"\n}\n");
        discordChatStyle.set("discordScreenshotMessageWebhookStyle", (Object)discordScreenshotMessageWebhookStyle.replace("\r", ""));
        discordChatStyle.setComment("discordScreenshotMessageWebhookStyle", " Screenshot from player (if webhook mode is enabled)\n Parameters: {player}, {screenshot_url}");
        discordScreenshotMessageWebhookStyle = DiscordChatStyleConfig.validateJsonValue(discordScreenshotMessageWebhookStyle, "{\n    \"content\": \"\"\n}\n");
        discordServerStartedMessageStyle = existedDiscordChatStyle.getOrElse("discordServerStartedMessageStyle", "{\n    \"embed\": {\n        \"description\": \"{discord_chat_mod.server.started} <t:{timestamp}:R>\",\n        \"color\": \"#2ECC71\"\n    }\n}\n");
        discordChatStyle.set("discordServerStartedMessageStyle", (Object)discordServerStartedMessageStyle.replace("\r", ""));
        discordChatStyle.setComment("discordServerStartedMessageStyle", " Server started message\n Parameters: {discord_chat_mod.server.started}");
        discordServerStartedMessageStyle = DiscordChatStyleConfig.validateJsonValue(discordServerStartedMessageStyle, "{\n    \"embed\": {\n        \"description\": \"{discord_chat_mod.server.started} <t:{timestamp}:R>\",\n        \"color\": \"#2ECC71\"\n    }\n}\n");
        discordLocalServerStartedMessageStyle = existedDiscordChatStyle.getOrElse("discordLocalServerStartedMessageStyle", "{\n    \"embed\": {\n        \"description\": \"{discord_chat_mod.server.local_started} <t:{timestamp}:R>\",\n        \"color\": \"#2ECC71\"\n    }\n}\n");
        discordChatStyle.set("discordLocalServerStartedMessageStyle", (Object)discordLocalServerStartedMessageStyle.replace("\r", ""));
        discordChatStyle.setComment("discordLocalServerStartedMessageStyle", " Local server started message\n Parameters: {discord_chat_mod.server.local_started}, {server_port}");
        discordLocalServerStartedMessageStyle = DiscordChatStyleConfig.validateJsonValue(discordLocalServerStartedMessageStyle, "{\n    \"embed\": {\n        \"description\": \"{discord_chat_mod.server.local_started} <t:{timestamp}:R>\",\n        \"color\": \"#2ECC71\"\n    }\n}\n");
        discordServerClosedMessageStyle = existedDiscordChatStyle.getOrElse("discordServerClosedMessageStyle", "{\n    \"embed\": {\n        \"description\": \"{discord_chat_mod.server.closed} <t:{timestamp}:R>\",\n        \"color\": \"#E74C3C\"\n    }\n}\n");
        discordChatStyle.set("discordServerClosedMessageStyle", (Object)discordServerClosedMessageStyle.replace("\r", ""));
        discordChatStyle.setComment("discordServerClosedMessageStyle", " Server closed message\n Parameters: {discord_chat_mod.server.closed}");
        discordServerClosedMessageStyle = DiscordChatStyleConfig.validateJsonValue(discordServerClosedMessageStyle, "{\n    \"embed\": {\n        \"description\": \"{discord_chat_mod.server.closed} <t:{timestamp}:R>\",\n        \"color\": \"#E74C3C\"\n    }\n}\n");
        discordPinnedStatusMessageServerUnavailableStyle = existedDiscordChatStyle.getOrElse("discordPinnedStatusMessageServerUnavailableStyle", "{\n    \"embed\": {\n        \"description\": \"{discord_chat_mod.server.status.unavailable}\",\n        \"color\": \"#E74C3C\"\n    }\n}\n");
        discordChatStyle.set("discordPinnedStatusMessageServerUnavailableStyle", (Object)discordPinnedStatusMessageServerUnavailableStyle.replace("\r", ""));
        discordChatStyle.setComment("discordPinnedStatusMessageServerUnavailableStyle", " Pinned server status message when server is unavailable\n Parameters: {discord_chat_mod.server.status.unavailable}");
        discordPinnedStatusMessageServerUnavailableStyle = DiscordChatStyleConfig.validateJsonValue(discordPinnedStatusMessageServerUnavailableStyle, "{\n    \"embed\": {\n        \"description\": \"{discord_chat_mod.server.status.unavailable}\",\n        \"color\": \"#E74C3C\"\n    }\n}\n");
        discordPinnedStatusMessageServerAvailableStyle = existedDiscordChatStyle.getOrElse("discordPinnedStatusMessageServerAvailableStyle", "{\n    \"embed\": {\n        \"description\": \"{discord_chat_mod.server.status.available}\",\n        \"color\": \"#1F8B4C\"\n    }\n}\n");
        discordChatStyle.set("discordPinnedStatusMessageServerAvailableStyle", (Object)discordPinnedStatusMessageServerAvailableStyle.replace("\r", ""));
        discordChatStyle.setComment("discordPinnedStatusMessageServerAvailableStyle", " Pinned server status message when server is available but there are no players\n Parameters: {discord_chat_mod.server.status.available}");
        discordPinnedStatusMessageServerAvailableStyle = DiscordChatStyleConfig.validateJsonValue(discordPinnedStatusMessageServerAvailableStyle, "{\n    \"embed\": {\n        \"description\": \"{discord_chat_mod.server.status.available}\",\n        \"color\": \"#1F8B4C\"\n    }\n}\n");
        discordPinnedStatusMessagePlayerListDelimiter = existedDiscordChatStyle.getOrElse("discordPinnedStatusMessagePlayerListDelimiter", "\n");
        discordChatStyle.set("discordPinnedStatusMessagePlayerListDelimiter", (Object)discordPinnedStatusMessagePlayerListDelimiter);
        discordChatStyle.setComment("discordPinnedStatusMessagePlayerListDelimiter", " The characters separating player nicknames in the {player_list} parameter for the pinned status message style");
        discordPinnedStatusMessagePlayerListNicknameStyle = existedDiscordChatStyle.getOrElse("discordPinnedStatusMessagePlayerListNicknameStyle", "{player}");
        discordChatStyle.set("discordPinnedStatusMessagePlayerListNicknameStyle", (Object)discordPinnedStatusMessagePlayerListNicknameStyle);
        discordChatStyle.setComment("discordPinnedStatusMessagePlayerListNicknameStyle", " Style of a single nickname in the {player_list} parameter of a pinned status message\n Parameters: {player}, {counter} \u2014 can be used to number players in order");
        discordPinnedStatusMessageStyle = existedDiscordChatStyle.getOrElse("discordPinnedStatusMessageStyle", "{\n    \"embed\": {\n        \"title\": \"{discord_chat_mod.server.status.online_players}\",\n        \"description\": \"{player_list}\",\n        \"color\": \"#2ECC71\"\n    }\n}\n");
        discordChatStyle.set("discordPinnedStatusMessageStyle", (Object)discordPinnedStatusMessageStyle.replace("\r", ""));
        discordChatStyle.setComment("discordPinnedStatusMessageStyle", " Pinned server status message when there are players on the server\n Parameters: {discord_chat_mod.server.status.online_players}, {player_list}, {player_count}, {max_players}");
        discordPinnedStatusMessageStyle = DiscordChatStyleConfig.validateJsonValue(discordPinnedStatusMessageStyle, "{\n    \"embed\": {\n        \"title\": \"{discord_chat_mod.server.status.online_players}\",\n        \"description\": \"{player_list}\",\n        \"color\": \"#2ECC71\"\n    }\n}\n");
        discordGuildForwardedMessageUserNameStyle = existedDiscordChatStyle.getOrElse("discordGuildForwardedMessageUserNameStyle", "{user} ({guild})");
        discordChatStyle.set("discordGuildForwardedMessageUserNameStyle", (Object)discordGuildForwardedMessageUserNameStyle);
        discordChatStyle.setComment("discordGuildForwardedMessageUserNameStyle", " The username displayed in Discord when forwarding a message from another guild\n Parameters: {member}, {user}, {guild}");
        return discordChatStyle;
    }

    private static String validateJsonValue(String jsonValue, String defaultValue) {
        if (jsonValue.isBlank()) {
            return defaultValue;
        }
        try {
            JsonObject jsonObject = (JsonObject)GSON.fromJson(jsonValue, JsonObject.class);
            if (!jsonObject.has("content") && !jsonObject.has("embed")) {
                throw new JsonSyntaxException("Json should contains \"content\" or \"embed\" keys");
            }
            return jsonValue.replace("\r", "");
        }
        catch (JsonSyntaxException e) {
            LOGGER.warn("Error on parsing discord message style json: {}", (Object)e.getMessage());
            LOGGER.warn(jsonValue.replace("\r", ""));
            LOGGER.warn("Default style will be used");
            return defaultValue;
        }
    }
}

