/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.config.configs;

import com.denisnumb.discord_chat_mod.discord.model.ChannelCategory;
import com.mojang.logging.LogUtils;
import com.shadow.com.electronwill.nightconfig.core.CommentedConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class DiscordGuildsConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static List<DiscordGuildConfig> discordGuildConfigs;

    public static List<CommentedConfig> loadDiscordGuildsConfig(CommentedConfig commonConfig) {
        List<CommentedConfig> guildList = commonConfig.getOrElse("guilds", DiscordGuildsConfig.setDefaultGuildConfig(commonConfig));
        discordGuildConfigs = new ArrayList<DiscordGuildConfig>();
        for (CommentedConfig guild : guildList) {
            String guildId = guild.getOrElse("guildId", "");
            if (discordGuildConfigs.stream().map(DiscordGuildConfig::guildId).toList().contains(guildId)) continue;
            String mainChannelId = guild.getOrElse("defaultChannelId", "");
            boolean enablePinnedStatusMessage = guild.getOrElse("enablePinnedStatusMessage", Boolean.valueOf(true));
            CommentedConfig overrides = (CommentedConfig)guild.get("channelOverrides");
            boolean duplicateMessages = overrides.getOrElse("duplicateMessages", Boolean.valueOf(false));
            HashMap<String, String> channelOverrides = new HashMap<String, String>();
            for (CommentedConfig.Entry entry : overrides.entrySet()) {
                if (entry.getKey().equals("duplicateMessages")) continue;
                String key = entry.getKey();
                String value = (String)entry.getValue();
                boolean valid = false;
                for (ChannelCategory cat : ChannelCategory.values()) {
                    if (!cat.getConfigName().equalsIgnoreCase(key)) continue;
                    valid = true;
                    channelOverrides.put(cat.getConfigName(), value);
                    break;
                }
                if (valid) continue;
                LOGGER.error("Unknown channel key \"{}\" in channel overrides for guildId: {}", (Object)key, (Object)guildId);
            }
            discordGuildConfigs.add(new DiscordGuildConfig(guildId, mainChannelId, duplicateMessages, enablePinnedStatusMessage, channelOverrides));
        }
        return guildList;
    }

    private static List<CommentedConfig> setDefaultGuildConfig(CommentedConfig commonConfig) {
        CommentedConfig exampleServer = commonConfig.createSubConfig();
        exampleServer.set("guildId", (Object)"");
        exampleServer.setComment("guildId", " The [[guilds]] section is used to define the main and additional channels within a specific discord guild.\n You can copy this section entirely and define another discord guild in the configuration.\n In the guildId field you must specify the identifier of the discord guild to which all the channels listed below belong.");
        exampleServer.set("defaultChannelId", (Object)"");
        exampleServer.setComment("defaultChannelId", " Discord channel ID for messaging with MineCraft\n [!] Make sure the bot has access to the channel and all the permissions listed above.");
        exampleServer.set("enablePinnedStatusMessage", (Object)true);
        exampleServer.setComment("enablePinnedStatusMessage", " Create a pinned message with the current server status and player list");
        CommentedConfig overrides = exampleServer.createSubConfig();
        overrides.set("duplicateMessages", (Object)false);
        overrides.setComment("duplicateMessages", " If true, messages will still be sent to the main channel, but will also be duplicated to the specified channels.");
        for (ChannelCategory category : ChannelCategory.values()) {
            overrides.set(category.getConfigName(), (Object)"");
            overrides.setComment(category.getConfigName(), category.getConfigComment());
        }
        exampleServer.set("channelOverrides", (Object)overrides);
        List<CommentedConfig> guildList = List.of(exampleServer);
        commonConfig.add("guilds", guildList);
        return guildList;
    }

    public record DiscordGuildConfig(String guildId, String defaultChannelId, boolean duplicateMessages, boolean enablePinnedStatusMessage, Map<String, String> channelOverrides) {
    }
}

