/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.discord;

import com.denisnumb.discord_chat_mod.DiscordChatMod;
import com.denisnumb.discord_chat_mod.discord.DiscordChannelRegistry;
import com.denisnumb.discord_chat_mod.discord.model.ChannelCategory;
import com.denisnumb.discord_chat_mod.discord.model.DiscordUserData;
import com.shadow.net.dv8tion.jda.api.OnlineStatus;
import com.shadow.net.dv8tion.jda.api.entities.Member;
import com.shadow.net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ChannelMembersProvider {
    private static long lastGetChannelMembers = 0L;
    private static List<Member> cachedMembersList;
    public static List<DiscordUserData> CLIENT_MEMBER_CACHE;

    public static void dropTimeouts() {
        lastGetChannelMembers = 0L;
    }

    public static List<DiscordUserData> getMemberData(ChannelCategory channelCategoryToParseMembers) {
        if (!DiscordChatMod.isDiscordConnected()) {
            return List.of();
        }
        return ChannelMembersProvider.getList(channelCategoryToParseMembers).stream().map(member -> new DiscordUserData(ChannelMembersProvider.getMemberDisplayName(member), member.getUser().getName(), member.getAsMention(), member.getColor())).toList();
    }

    public static String getMemberDisplayName(Member member) {
        return DiscordChannelRegistry.getAllContexts().size() > 1 ? member.getUser().getEffectiveName() : member.getEffectiveName();
    }

    private static List<Member> getList(ChannelCategory channelCategoryToParseMembers) {
        if (System.currentTimeMillis() - lastGetChannelMembers < 5000L) {
            return cachedMembersList;
        }
        lastGetChannelMembers = System.currentTimeMillis();
        List members = DiscordChannelRegistry.getAllContexts().stream().flatMap(guildContext -> {
            GuildMessageChannel channel = guildContext.getDefaultChannelIfCategoryDisabled(channelCategoryToParseMembers);
            if (channel == null) {
                return Stream.empty();
            }
            return guildContext.getGuild().getMembers().stream().filter(member -> member.hasAccess(channel));
        }).collect(Collectors.toMap(member -> member.getUser().getIdLong(), Function.identity(), (first, duplicate) -> first)).values().stream().toList();
        Stream<Member> onlineStream = members.stream().filter(member -> member.getOnlineStatus() != OnlineStatus.OFFLINE).sorted((m1, m2) -> {
            int m2RolePosition;
            int m1RolePosition = m1.getRoles().isEmpty() ? 0 : m1.getRoles().getFirst().getPosition();
            int n = m2RolePosition = m2.getRoles().isEmpty() ? 0 : m2.getRoles().getFirst().getPosition();
            if (m1RolePosition != m2RolePosition) {
                return Integer.compare(m2RolePosition, m1RolePosition);
            }
            return m1.getEffectiveName().compareToIgnoreCase(m2.getEffectiveName());
        });
        Stream<Member> offlineStream = members.stream().filter(member -> member.getOnlineStatus() == OnlineStatus.OFFLINE).sorted((m1, m2) -> m1.getEffectiveName().compareToIgnoreCase(m2.getEffectiveName()));
        cachedMembersList = Stream.concat(onlineStream, offlineStream).toList();
        return cachedMembersList;
    }

    static {
        CLIENT_MEMBER_CACHE = List.of();
    }
}

