/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.discord;

import com.denisnumb.discord_chat_mod.DiscordChatMod;
import com.denisnumb.discord_chat_mod.LocaleProvider;
import com.denisnumb.discord_chat_mod.MinecraftUtils;
import com.denisnumb.discord_chat_mod.chat_images.utils.ImageUtils;
import com.denisnumb.discord_chat_mod.config.ConfigProvider;
import com.denisnumb.discord_chat_mod.config.IConfigProvider;
import com.denisnumb.discord_chat_mod.config.configs.DiscordGuildsConfig;
import com.denisnumb.discord_chat_mod.discord.model.ChannelCategory;
import com.denisnumb.discord_chat_mod.discord.model.DiscordGuildContext;
import com.shadow.net.dv8tion.jda.api.Permission;
import com.shadow.net.dv8tion.jda.api.entities.Guild;
import com.shadow.net.dv8tion.jda.api.entities.Icon;
import com.shadow.net.dv8tion.jda.api.entities.SelfMember;
import com.shadow.net.dv8tion.jda.api.entities.Webhook;
import com.shadow.net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import com.shadow.net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import com.shadow.net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class DiscordChannelRegistry {
    private static final Map<String, DiscordGuildContext> GUILD_CONTEXTS = new HashMap<String, DiscordGuildContext>();
    @Nullable
    public static GuildMessageChannel serverLogsChannel;
    private static Icon webhookAvatar;
    private static final List<Permission> requiredPermissions;

    public static DiscordGuildContext getContext(String guildId) {
        return GUILD_CONTEXTS.get(guildId);
    }

    public static List<DiscordGuildContext> getAllContexts() {
        return GUILD_CONTEXTS.values().stream().toList();
    }

    public static boolean isChannelCategoryDisabled(@Nullable GuildMessageChannel channel) {
        return channel == null;
    }

    public static void initDiscordChannels(List<DiscordGuildsConfig.DiscordGuildConfig> guildConfigs) throws Exception {
        GUILD_CONTEXTS.clear();
        IConfigProvider config = ConfigProvider.getConfig();
        String webhookAvatarUrl = ImageUtils.isImageUrl(ImageUtils.getMimeType(config.webhookServerAvatarUrl())) ? config.webhookServerAvatarUrl() : DiscordChatMod.jda.getSelfUser().getAvatarUrl();
        webhookAvatar = webhookAvatarUrl == null ? null : Icon.from(ImageUtils.getInputStreamFromUrl(webhookAvatarUrl));
        serverLogsChannel = DiscordChannelRegistry.getDiscordChannel(null, config.serverLogsChannelId());
        for (DiscordGuildsConfig.DiscordGuildConfig guildConfig : guildConfigs) {
            if (guildConfig.guildId().isEmpty()) continue;
            Guild guild = DiscordChatMod.jda.getGuildById(guildConfig.guildId());
            if (guild == null) {
                MinecraftUtils.logErrorToServer(String.format(LocaleProvider.getTranslate("discord_chat_mod.error.invalid_guild_error"), guildConfig.guildId()));
                continue;
            }
            DiscordGuildContext context = new DiscordGuildContext(guild, guildConfig.duplicateMessages(), guildConfig.enablePinnedStatusMessage());
            try {
                context.setDefaultChannel(DiscordChannelRegistry.getDiscordChannel(context, guildConfig.defaultChannelId()));
            }
            catch (IllegalStateException e) {
                MinecraftUtils.logErrorToServer(String.format(LocaleProvider.getTranslate("discord_chat_mod.error.invalid_default_channel_error"), guild.getName()));
                continue;
            }
            for (Map.Entry<String, String> entry : guildConfig.channelOverrides().entrySet()) {
                ChannelCategory category = ChannelCategory.fromConfigName(entry.getKey());
                String channelId = entry.getValue();
                if (channelId.equals("-1")) {
                    if (category == ChannelCategory.PINNED_STATUS) continue;
                    context.setChannel(category, null);
                    continue;
                }
                GuildMessageChannel channel = DiscordChannelRegistry.getDiscordChannel(context, channelId);
                if (channel == null) continue;
                context.setChannel(category, channel);
            }
            GUILD_CONTEXTS.put(guildConfig.guildId(), context);
        }
        if (GUILD_CONTEXTS.isEmpty()) {
            MinecraftUtils.logWarnToServer(LocaleProvider.getTranslate("discord_chat_mod.warn.no_guilds_configured"));
        }
    }

    @Nullable
    private static GuildMessageChannel getDiscordChannel(@Nullable DiscordGuildContext context, String channelId) {
        if (context != null && context.CHANNEL_CACHE.containsKey(channelId)) {
            return context.CHANNEL_CACHE.get(channelId);
        }
        if (!channelId.isEmpty()) {
            try {
                GuildMessageChannel channel;
                GuildMessageChannel guildMessageChannel = channel = context == null ? DiscordChatMod.jda.getChannelById(GuildMessageChannel.class, channelId) : context.guild.getChannelById(GuildMessageChannel.class, channelId);
                if (channel == null) {
                    throw new IllegalArgumentException(String.format(LocaleProvider.getTranslate("discord_chat_mod.error.invalid_channel_error"), channelId));
                }
                DiscordChannelRegistry.checkDiscordBotPermissionsInChannel(channel);
                DiscordChannelRegistry.initChannelWebhook(context, channel);
                if (context != null) {
                    context.CHANNEL_CACHE.put(channelId, channel);
                }
                return channel;
            }
            catch (Exception e) {
                MinecraftUtils.logErrorToServer(e.getMessage());
            }
        }
        return null;
    }

    private static void initChannelWebhook(@Nullable DiscordGuildContext context, GuildMessageChannel channel) {
        if (context == null || !ConfigProvider.getConfig().isWebhookModeEnabled()) {
            return;
        }
        if (channel instanceof TextChannel) {
            TextChannel textChannel = (TextChannel)channel;
            if (!textChannel.getGuild().getSelfMember().hasPermission((GuildChannel)textChannel, Permission.MANAGE_WEBHOOKS)) {
                MinecraftUtils.logWarnToServer(String.format(LocaleProvider.getTranslate("discord_chat_mod.webhook.error"), String.format(LocaleProvider.getTranslate("discord_chat_mod.webhook.error.missing_permission"), "#" + channel.getName())));
                return;
            }
            Webhook webhook = textChannel.retrieveWebhooks().complete().stream().filter(wh -> DiscordChatMod.jda.getSelfUser().equals(wh.getOwnerAsUser())).findFirst().orElse(null);
            try {
                if (webhook == null) {
                    webhook = (Webhook)textChannel.createWebhook("DC & Chat Images").setAvatar(webhookAvatar).complete();
                } else {
                    webhook.getManager().setAvatar(webhookAvatar).queue();
                }
                context.registerWebhook(channel, webhook);
            }
            catch (Exception e) {
                MinecraftUtils.logWarnToServer(String.format(LocaleProvider.getTranslate("discord_chat_mod.webhook.error"), e.getMessage()));
            }
        } else {
            MinecraftUtils.logWarnToServer(String.format(LocaleProvider.getTranslate("discord_chat_mod.webhook.error"), String.format(LocaleProvider.getTranslate("discord_chat_mod.webhook.error.invalid_channel_type"), "#" + channel.getName())));
        }
    }

    private static void checkDiscordBotPermissionsInChannel(GuildMessageChannel channel) throws IllegalStateException {
        SelfMember selfMember = channel.getGuild().getSelfMember();
        EnumSet missingPermissions = requiredPermissions.stream().filter(perm -> !selfMember.hasPermission((GuildChannel)channel, (Permission)((Object)perm))).collect(Collectors.toCollection(() -> EnumSet.noneOf(Permission.class)));
        if (!missingPermissions.isEmpty()) {
            throw new IllegalStateException(String.format(LocaleProvider.getTranslate("discord_chat_mod.error.missing_permissions_error"), "#" + channel.getName(), String.join((CharSequence)"\n", missingPermissions.stream().map(Permission::getName).toList())));
        }
    }

    static {
        requiredPermissions = List.of(Permission.VIEW_CHANNEL, Permission.MESSAGE_SEND, Permission.MESSAGE_SEND_IN_THREADS, Permission.MESSAGE_EMBED_LINKS, Permission.MESSAGE_ATTACH_FILES, Permission.PIN_MESSAGES, Permission.MESSAGE_HISTORY);
    }
}

