/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.discord;

import com.denisnumb.discord_chat_mod.ColorUtils;
import com.denisnumb.discord_chat_mod.DiscordChatMod;
import com.denisnumb.discord_chat_mod.LocaleProvider;
import com.denisnumb.discord_chat_mod.MinecraftUtils;
import com.denisnumb.discord_chat_mod.chat_images.utils.ImageUtils;
import com.denisnumb.discord_chat_mod.chat_style.ChatStyleUtils;
import com.denisnumb.discord_chat_mod.config.ConfigProvider;
import com.denisnumb.discord_chat_mod.discord.ChannelMembersProvider;
import com.denisnumb.discord_chat_mod.discord.DiscordChannelRegistry;
import com.denisnumb.discord_chat_mod.discord.DiscordUtils;
import com.denisnumb.discord_chat_mod.discord.WebhookUtils;
import com.denisnumb.discord_chat_mod.discord.chat_style.DiscordChatStyleProvider;
import com.denisnumb.discord_chat_mod.discord.model.DiscordGuildContext;
import com.denisnumb.discord_chat_mod.discord.model.DiscordMentionData;
import com.denisnumb.discord_chat_mod.markdown.MarkdownParser;
import com.denisnumb.discord_chat_mod.markdown.MarkdownToComponentConverter;
import com.shadow.net.dv8tion.jda.api.entities.Member;
import com.shadow.net.dv8tion.jda.api.entities.Message;
import com.shadow.net.dv8tion.jda.api.entities.MessageEmbed;
import com.shadow.net.dv8tion.jda.api.entities.Role;
import com.shadow.net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import com.shadow.net.dv8tion.jda.api.entities.sticker.StickerItem;
import com.shadow.net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import com.shadow.net.dv8tion.jda.api.hooks.ListenerAdapter;
import com.shadow.net.dv8tion.jda.api.utils.FileUpload;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class DiscordEvents
extends ListenerAdapter {
    @Override
    public void onMessageReceived(MessageReceivedEvent event) {
        if (event.isWebhookMessage() || event.getAuthor().getId().equals(DiscordChatMod.jda.getSelfUser().getId())) {
            return;
        }
        if (!DiscordChannelRegistry.getAllContexts().stream().map(ctx -> ctx.getDefaultChannel().getId()).toList().contains(event.getMessage().getChannelId())) {
            return;
        }
        if (ConfigProvider.getConfig().isDiscordMessagesLoggingEnabled()) {
            System.out.printf("[Discord] <%s> %s%n", event.getAuthor().getEffectiveName(), event.getMessage().getContentDisplay());
        }
        if (MinecraftUtils.getServerPlayerCount(DiscordChatMod.server) > 0) {
            for (Component component : DiscordEvents.prepareComponents(event.getMessage())) {
                MinecraftUtils.sendMessageToAllPlayers(component);
            }
        }
        for (DiscordGuildContext guildContext : DiscordChannelRegistry.getAllContexts()) {
            if (guildContext.defaultChannel.getId().equals(event.getMessage().getChannelId())) continue;
            DiscordEvents.retranslateGuildMessage(guildContext, event);
        }
    }

    public static void retranslateGuildMessage(DiscordGuildContext guildContext, MessageReceivedEvent event) {
        List<MessageEmbed> embeds = event.getMessage().getEmbeds();
        MessageEmbed embed = embeds.isEmpty() ? null : event.getMessage().getEmbeds().getFirst();
        ArrayList<WebhookUtils.WebhookAttachment> attachments = new ArrayList<WebhookUtils.WebhookAttachment>();
        for (Message.Attachment attachment : event.getMessage().getAttachments()) {
            try {
                attachments.add(new WebhookUtils.WebhookAttachment(ImageUtils.getInputStreamFromUrl(attachment.getUrl()).readAllBytes(), attachment.getFileName()));
            }
            catch (Exception exception) {}
        }
        if (attachments.size() < 10 && !event.getMessage().getStickers().isEmpty()) {
            StickerItem sticker = event.getMessage().getStickers().getFirst();
            try {
                attachments.add(new WebhookUtils.WebhookAttachment(ImageUtils.getInputStreamFromUrl(sticker.getIconUrl()).readAllBytes(), DiscordUtils.getStickerFileName(sticker.getIconUrl())));
            }
            catch (Exception attachment) {
                // empty catch block
            }
        }
        String userName = ConfigProvider.getConfig().discordGuildForwardedMessageUserNameStyle().replace("{user}", event.getAuthor().getGlobalName()).replace("{member}", event.getMember().getEffectiveName()).replace("{guild}", event.getGuild().getName());
        String messageContent = event.getMessage().getContentRaw();
        guildContext.getWebhook(guildContext.defaultChannel).ifPresentOrElse(webhook -> WebhookUtils.sendWebhookWithFiles(webhook.getUrl(), new WebhookUtils.WebhookPayload(messageContent, embed).setAvatarUrl(event.getAuthor().getAvatarUrl()).setUsername(userName), attachments), () -> {
            String message = String.format(LocaleProvider.getTranslate("discord_chat_mod.forwarded_guild_message"), event.getMember().getEffectiveName(), event.getGuild().getName()) + "\n" + messageContent;
            DiscordUtils.prepareDiscordMessage(guildContext.defaultChannel, new DiscordChatStyleProvider.DiscordMessageComponents(Optional.of(message), embed == null ? Optional.empty() : Optional.of(embed))).ifPresent(mca -> {
                for (WebhookUtils.WebhookAttachment attachment : attachments) {
                    mca.addFiles(FileUpload.fromData(attachment.data(), attachment.fileName()));
                }
                DiscordUtils.sendDiscordMessage(mca, guildContext.defaultChannel, false);
            });
        });
    }

    @NotNull
    private static List<Component> prepareComponents(Message message) {
        ArrayList<Component> components = new ArrayList<Component>();
        Member member = Objects.requireNonNull(message.getMember());
        String userName = member.getEffectiveName();
        Color roleColor = member.getColor() == null ? Color.WHITE : member.getColor();
        String configTemplate = ConfigProvider.getConfig().minecraftDiscordMessagesStyle();
        MutableComponent guildComponent = Component.literal((String)message.getGuild().getName());
        MutableComponent userNameComponent = Component.empty().append((Component)Component.literal((String)userName).withColor(roleColor.getRGB()).withStyle(style -> style.withInsertion("@" + ChannelMembersProvider.getMemberDisplayName(member)).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/mention " + ChannelMembersProvider.getMemberDisplayName(member))).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)member.getUser().getName())))));
        if (!message.getContentRaw().isEmpty()) {
            MutableComponent textPart;
            HashMap<String, DiscordMentionData> mentions = new HashMap<String, DiscordMentionData>();
            for (Member user : message.getMentions().getMembers()) {
                mentions.put(user.getAsMention(), new DiscordMentionData(user));
            }
            for (Role role : message.getMentions().getRoles()) {
                mentions.put(role.getAsMention(), new DiscordMentionData(role));
            }
            for (GuildChannel channel : message.getMentions().getChannels()) {
                mentions.put(channel.getAsMention(), new DiscordMentionData(channel));
            }
            try {
                textPart = new MarkdownToComponentConverter(MarkdownParser.parseMarkdown(DiscordUtils.replaceDiscordEmojiMentionsToEmojiNames(message.getContentRaw())), mentions).convertMarkdownTokensToComponent();
            }
            catch (Exception ignored) {
                String content = message.getContentRaw();
                for (Map.Entry entry : mentions.entrySet()) {
                    content = content.replace((CharSequence)entry.getKey(), ((DiscordMentionData)entry.getValue()).prettyMention);
                }
                textPart = Component.literal((String)content);
            }
            DiscordEvents.addComponentsPart(components, configTemplate, (Component)guildComponent, (Component)userNameComponent, (Component)textPart);
        }
        if (!message.getAttachments().isEmpty()) {
            MutableComponent attachmentPart = Component.empty();
            int index = 0;
            List<Message.Attachment> attachments = message.getAttachments();
            for (Message.Attachment file : attachments) {
                attachmentPart.append((Component)Component.literal((String)(file.getFileName() + (++index < attachments.size() ? "\n" : ""))).withColor(ColorUtils.Color.CHAT_LINK_COLOR).withStyle(style -> style.withItalic(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, file.getUrl())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)file.getUrl())))));
            }
            DiscordEvents.addComponentsPart(components, configTemplate, (Component)guildComponent, (Component)userNameComponent, (Component)attachmentPart);
        }
        if (!message.getStickers().isEmpty()) {
            MutableComponent stickerPart = Component.empty();
            StickerItem sticker = message.getStickers().getFirst();
            stickerPart.append((Component)Component.literal((String)String.format(LocaleProvider.getTranslate("discord_chat_mod.sticker"), sticker.getName())).withStyle(style -> style.withItalic(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, sticker.getIconUrl()))));
            DiscordEvents.addComponentsPart(components, configTemplate, (Component)guildComponent, (Component)userNameComponent, (Component)stickerPart);
        }
        return components;
    }

    private static void addComponentsPart(ArrayList<Component> components, String configTemplate, Component guildComponent, Component userNameComponent, Component messageComponent) {
        components.add((Component)ChatStyleUtils.applyParametersToTemplate(ChatStyleUtils.parseConfigTemplateMarkdown(configTemplate), Map.of("{guild}", guildComponent, "{member}", userNameComponent, "{message}", messageComponent)));
    }
}

