/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.discord;

import com.denisnumb.discord_chat_mod.DiscordChatMod;
import com.denisnumb.discord_chat_mod.LocaleProvider;
import com.denisnumb.discord_chat_mod.MinecraftUtils;
import com.denisnumb.discord_chat_mod.chat_images.utils.ImageUtils;
import com.denisnumb.discord_chat_mod.discord.CustomEmojiProvider;
import com.denisnumb.discord_chat_mod.discord.DiscordChannelRegistry;
import com.denisnumb.discord_chat_mod.discord.StickersProvider;
import com.denisnumb.discord_chat_mod.discord.WebhookUtils;
import com.denisnumb.discord_chat_mod.discord.chat_style.DiscordChatStyleProvider;
import com.denisnumb.discord_chat_mod.discord.model.ChannelCategory;
import com.denisnumb.discord_chat_mod.discord.model.DiscordGuildContext;
import com.mojang.logging.LogUtils;
import com.shadow.net.dv8tion.jda.api.entities.Message;
import com.shadow.net.dv8tion.jda.api.entities.MessageEmbed;
import com.shadow.net.dv8tion.jda.api.entities.Webhook;
import com.shadow.net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import com.shadow.net.dv8tion.jda.api.entities.sticker.GuildSticker;
import com.shadow.net.dv8tion.jda.api.exceptions.ErrorResponseException;
import com.shadow.net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import com.shadow.net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import com.shadow.net.dv8tion.jda.api.requests.restaction.MessageEditAction;
import com.shadow.net.dv8tion.jda.api.utils.FileUpload;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class DiscordUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static ExecutorService EXECUTOR;

    public static void initDiscordSendExecutor() {
        EXECUTOR = Executors.newFixedThreadPool(5);
    }

    public static void stopDiscordSendExecutor() {
        if (EXECUTOR != null) {
            EXECUTOR.shutdownNow();
            EXECUTOR = null;
        }
    }

    public static void handleDiscord(Runnable prepareMessageFunc) {
        if (DiscordChatMod.isDiscordConnected() && EXECUTOR != null) {
            EXECUTOR.submit(prepareMessageFunc);
        }
    }

    public static Optional<String> sendMessageFromPlayer(ChannelCategory channelCategory, List<DiscordGuildContext> guildContexts, Player player, DiscordChatStyleProvider.DiscordMessageComponents messageComponentsWebhook, DiscordChatStyleProvider.DiscordMessageComponents messageComponents, ImageData imageData) {
        Optional<String> optionalScreenshotUrl = Optional.empty();
        for (DiscordGuildContext guildContext : guildContexts) {
            GuildMessageChannel channel = guildContext.getChannel(channelCategory);
            if (DiscordChannelRegistry.isChannelCategoryDisabled(channel)) continue;
            if (optionalScreenshotUrl.isEmpty()) {
                optionalScreenshotUrl = DiscordUtils.sendScreenshotFromPlayerToChannel(guildContext, channel, player, messageComponentsWebhook, messageComponents, imageData);
            }
            DiscordUtils.duplicateMessageToDefaultChannel(guildContext, channelCategory, () -> DiscordUtils.sendScreenshotFromPlayerToChannel(guildContext, guildContext.defaultChannel, player, messageComponentsWebhook, messageComponents, imageData));
        }
        return optionalScreenshotUrl;
    }

    private static Optional<String> sendScreenshotFromPlayerToChannel(DiscordGuildContext guildContext, GuildMessageChannel channel, Player player, DiscordChatStyleProvider.DiscordMessageComponents messageComponentsWebhook, DiscordChatStyleProvider.DiscordMessageComponents messageComponents, ImageData imageData) {
        Optional<Webhook> optionalWebhook = guildContext.getWebhook(channel);
        if (optionalWebhook.isEmpty()) {
            return DiscordUtils.prepareDiscordMessage(channel, messageComponents).flatMap(mca -> DiscordUtils.sendDiscordMessage((MessageCreateAction)mca.addFiles(FileUpload.fromData(imageData.data, imageData.fileName)), channel, true).flatMap(message -> message.getAttachments().stream().findFirst().map(Message.Attachment::getUrl)));
        }
        try {
            WebhookUtils.WebhookPayload payload = messageComponentsWebhook.hasContentAndEmbed() ? new WebhookUtils.WebhookPayload(messageComponentsWebhook.getContent(), messageComponentsWebhook.getEmbed()) : (messageComponentsWebhook.hasNoEmbed() ? new WebhookUtils.WebhookPayload(messageComponentsWebhook.getContent()) : new WebhookUtils.WebhookPayload(messageComponentsWebhook.getEmbed()));
            return WebhookUtils.sendWebhookWithImage(optionalWebhook.get().getUrl(), payload.setUsername(player.getName().getString()).setAvatarUrl(WebhookUtils.getPlayerAvatarUrl(player)), new WebhookUtils.WebhookAttachment(imageData.data(), imageData.fileName())).get();
        }
        catch (Exception ignored) {
            return Optional.empty();
        }
    }

    public static void sendMessageFromServer(ChannelCategory channelCategory, List<DiscordGuildContext> guildContexts, DiscordChatStyleProvider.DiscordMessageComponents messageComponents) {
        DiscordUtils.sendMessage(channelCategory, guildContexts, null, messageComponents, messageComponents, null, null);
    }

    public static void sendMessageFromServer(ChannelCategory channelCategory, List<DiscordGuildContext> guildContexts, DiscordChatStyleProvider.DiscordMessageComponents messageComponents, ImageData imageData) {
        DiscordUtils.sendMessage(channelCategory, guildContexts, null, messageComponents, messageComponents, imageData, null);
    }

    public static void sendMessageFromPlayer(ChannelCategory channelCategory, List<DiscordGuildContext> guildContexts, Player player, DiscordChatStyleProvider.DiscordMessageComponents messageComponentsWebhook, DiscordChatStyleProvider.DiscordMessageComponents messageComponents) {
        DiscordUtils.sendMessage(channelCategory, guildContexts, player, messageComponentsWebhook, messageComponents, null, null);
    }

    public static void sendMessageFromPlayer(ChannelCategory channelCategory, List<DiscordGuildContext> guildContexts, Player player, DiscordChatStyleProvider.DiscordMessageComponents messageComponentsWebhook, DiscordChatStyleProvider.DiscordMessageComponents messageComponents, StickersProvider.StickerData stickerData) {
        DiscordUtils.sendMessage(channelCategory, guildContexts, player, messageComponentsWebhook, messageComponents, null, stickerData);
    }

    private static void sendMessage(ChannelCategory channelCategory, List<DiscordGuildContext> guildContexts, @Nullable Player player, DiscordChatStyleProvider.DiscordMessageComponents messageComponentsWebhook, DiscordChatStyleProvider.DiscordMessageComponents messageComponents, @Nullable ImageData imageData, @Nullable StickersProvider.StickerData stickerData) {
        for (DiscordGuildContext guildContext : guildContexts) {
            GuildMessageChannel channel = guildContext.getChannel(channelCategory);
            if (DiscordChannelRegistry.isChannelCategoryDisabled(channel)) continue;
            DiscordUtils.duplicateMessageToDefaultChannel(guildContext, channelCategory, () -> DiscordUtils.sendMessageToChannel(guildContext, guildContext.defaultChannel, player, messageComponentsWebhook, messageComponents, imageData, stickerData));
            DiscordUtils.sendMessageToChannel(guildContext, channel, player, messageComponentsWebhook, messageComponents, imageData, stickerData);
        }
    }

    private static void sendMessageToChannel(DiscordGuildContext guildContext, GuildMessageChannel channel, @Nullable Player player, DiscordChatStyleProvider.DiscordMessageComponents messageComponentsWebhook, DiscordChatStyleProvider.DiscordMessageComponents messageComponents, @Nullable ImageData imageData, @Nullable StickersProvider.StickerData stickerData) {
        guildContext.getWebhook(channel).ifPresentOrElse(webhook -> DiscordUtils.sendDiscordWebhookMessage(webhook.getUrl(), player, messageComponentsWebhook, imageData), () -> DiscordUtils.prepareDiscordMessage(channel, messageComponents).ifPresent(mca -> {
            if (imageData != null) {
                mca.addFiles(FileUpload.fromData(imageData.data, imageData.fileName));
            }
            if (stickerData != null) {
                GuildSticker sticker = guildContext.guild.getStickerById(stickerData.discordId());
                if (sticker != null) {
                    mca = mca.setStickers(sticker);
                } else {
                    try {
                        mca.addFiles(FileUpload.fromData(ImageUtils.getInputStreamFromUrl(stickerData.imageUrl()).readAllBytes(), DiscordUtils.getStickerFileName(stickerData.imageUrl())));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            DiscordUtils.sendDiscordMessage(mca, channel, false);
        }));
    }

    private static void sendDiscordWebhookMessage(String webhookUrl, @Nullable Player player, DiscordChatStyleProvider.DiscordMessageComponents components, @Nullable ImageData imageData) {
        WebhookUtils.WebhookPayload payload = components.hasContentAndEmbed() ? new WebhookUtils.WebhookPayload(components.getContent(), components.getEmbed()) : (components.hasNoEmbed() ? new WebhookUtils.WebhookPayload(components.getContent()) : new WebhookUtils.WebhookPayload(components.getEmbed()));
        payload.setUsername(player != null ? player.getName().getString() : WebhookUtils.getWebhookServerName());
        if (player != null) {
            payload.setAvatarUrl(WebhookUtils.getPlayerAvatarUrl(player));
        }
        if (imageData != null) {
            WebhookUtils.sendWebhookWithImage(webhookUrl, payload, new WebhookUtils.WebhookAttachment(imageData.data, imageData.fileName));
        } else {
            WebhookUtils.sendWebhook(webhookUrl, () -> payload);
        }
    }

    public static Optional<MessageCreateAction> prepareDiscordMessage(GuildMessageChannel channel, DiscordChatStyleProvider.DiscordMessageComponents messageComponents) {
        if (!DiscordChatMod.isDiscordConnected()) {
            return Optional.empty();
        }
        try {
            MessageCreateAction mca = messageComponents.hasContentAndEmbed() ? (MessageCreateAction)channel.sendMessage(messageComponents.getContent()).addEmbeds(messageComponents.getEmbed()) : (messageComponents.hasNoEmbed() ? channel.sendMessage(messageComponents.getContent()) : channel.sendMessageEmbeds(messageComponents.getEmbed(), new MessageEmbed[0]));
            return Optional.of(mca);
        }
        catch (InsufficientPermissionException e) {
            MinecraftUtils.logErrorToServer(String.format(LocaleProvider.getTranslate("discord_chat_mod.error.send_message_error_with_cause"), channel.getName(), e.getMessage()));
            e.printStackTrace();
        }
        catch (ErrorResponseException e) {
            MinecraftUtils.logErrorToServer(String.format(LocaleProvider.getTranslate("discord_chat_mod.error.send_message_error_with_cause"), channel.getName(), e.getMeaning()));
            e.printStackTrace();
        }
        catch (Exception e) {
            MinecraftUtils.logErrorToServer(String.format(LocaleProvider.getTranslate("discord_chat_mod.error.send_message_error"), channel.getName()));
            e.printStackTrace();
        }
        return Optional.empty();
    }

    public static Optional<Message> sendDiscordMessage(MessageCreateAction mca, GuildMessageChannel channel, boolean complete) {
        try {
            if (complete) {
                return Optional.of((Message)mca.complete());
            }
            mca.queue();
        }
        catch (InsufficientPermissionException e) {
            MinecraftUtils.logErrorToServer(String.format(LocaleProvider.getTranslate("discord_chat_mod.error.send_message_error_with_cause"), channel.getName(), e.getMessage()));
            e.printStackTrace();
        }
        catch (ErrorResponseException e) {
            MinecraftUtils.logErrorToServer(String.format(LocaleProvider.getTranslate("discord_chat_mod.error.send_message_error_with_cause"), channel.getName(), e.getMeaning()));
            e.printStackTrace();
        }
        catch (Exception e) {
            MinecraftUtils.logErrorToServer(String.format(LocaleProvider.getTranslate("discord_chat_mod.error.send_message_error"), channel.getName()));
            e.printStackTrace();
        }
        return Optional.empty();
    }

    public static void editMessage(Message message, DiscordChatStyleProvider.DiscordMessageComponents components) {
        try {
            if (components.hasContentAndEmbed()) {
                ((MessageEditAction)message.editMessage(components.getContent()).setEmbeds(components.getEmbed())).queue();
            } else if (components.hasNoEmbed()) {
                message.editMessage(components.getContent()).queue();
            } else {
                message.editMessageEmbeds(components.getEmbed()).queue();
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    private static void duplicateMessageToDefaultChannel(DiscordGuildContext context, ChannelCategory category, Runnable sendMessageFunction) {
        if (DiscordChatMod.isDiscordConnected() && context.duplicateMessages && !context.defaultChannel.equals(context.getChannel(category))) {
            sendMessageFunction.run();
        }
    }

    public static String getStickerFileName(String stickerUrl) {
        String[] parts = stickerUrl.split("\\.");
        return "sticker." + parts[parts.length - 1];
    }

    public static String replaceEmojiCodesToDiscordMentions(String text) {
        Pattern emojiPattern = Pattern.compile("(?<!\\\\):([a-zA-Z0-9_]{2,}(~[1-9][0-9]*)?):");
        Matcher matcher = emojiPattern.matcher(text);
        Map<String, CustomEmojiProvider.EmojiData> emojiMap = CustomEmojiProvider.getNameToEmojiDataMap();
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String indexedName = matcher.group(1);
            if (!emojiMap.containsKey(indexedName)) continue;
            matcher.appendReplacement(result, Matcher.quoteReplacement(emojiMap.get(indexedName).mentionString()));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static String replaceDiscordEmojiMentionsToEmojiNames(String text) {
        Pattern emojiMentionPattern = Pattern.compile("(?<!\\\\)<a?:[a-zA-Z0-9_]+:\\d+>");
        Matcher matcher = emojiMentionPattern.matcher(text);
        Map<String, CustomEmojiProvider.EmojiData> emojiMap = CustomEmojiProvider.getNameToEmojiDataMap();
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String mentionString = matcher.group();
            emojiMap.entrySet().stream().filter(entry -> ((CustomEmojiProvider.EmojiData)entry.getValue()).mentionString().equals(mentionString)).findFirst().map(Map.Entry::getKey).ifPresent(indexedName -> matcher.appendReplacement(result, Matcher.quoteReplacement(String.format(":%s:", indexedName))));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public record ImageData(String fileName, byte[] data) {
    }
}

