/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.discord.chat_style;

import com.denisnumb.discord_chat_mod.ColorUtils;
import com.denisnumb.discord_chat_mod.DeathMessageUtils;
import com.denisnumb.discord_chat_mod.chat_style.ChatStyleUtils;
import com.denisnumb.discord_chat_mod.config.ConfigProvider;
import com.denisnumb.discord_chat_mod.config.IConfigProvider;
import com.denisnumb.discord_chat_mod.discord.WebhookUtils;
import com.denisnumb.discord_chat_mod.discord.chat_style.MessageType;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.shadow.net.dv8tion.jda.api.EmbedBuilder;
import com.shadow.net.dv8tion.jda.api.entities.MessageEmbed;
import com.shadow.net.dv8tion.jda.api.utils.data.DataObject;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class DiscordChatStyleProvider {
    private static final Gson GSON = new Gson();
    private static final Logger LOGGER = LogUtils.getLogger();

    private static Optional<MessageEmbed> parseEmbedJson(JsonObject jsonTemplate) {
        if (!jsonTemplate.has("embed")) {
            return Optional.empty();
        }
        JsonObject embed = jsonTemplate.getAsJsonObject("embed");
        if (embed.has("color") && embed.getAsJsonPrimitive("color").isString()) {
            Integer parsedColor = ColorUtils.parseColor(embed.get("color").getAsString());
            if (parsedColor == null) {
                embed.remove("color");
            } else {
                embed.addProperty("color", (Number)parsedColor);
            }
        }
        return Optional.of(EmbedBuilder.fromData(DataObject.fromJson(GSON.toJson((JsonElement)embed))).build());
    }

    private static DiscordMessageComponents parseDiscordConfigTemplate(String jsonTemplate, Map<String, String> parameterMap) {
        for (Map.Entry<String, String> param : parameterMap.entrySet()) {
            jsonTemplate = jsonTemplate.replace(param.getKey(), param.getValue());
        }
        JsonObject parsedTemplate = (JsonObject)GSON.fromJson(jsonTemplate, JsonObject.class);
        Optional<String> content = parsedTemplate.has("content") ? Optional.of(parsedTemplate.get("content").getAsString()) : Optional.empty();
        Optional<MessageEmbed> embed = DiscordChatStyleProvider.parseEmbedJson(parsedTemplate);
        return new DiscordMessageComponents(content, embed);
    }

    public static String formatDeathMessageComponents(DeathMessageUtils.DeathMessageComponents components) {
        IConfigProvider config = ConfigProvider.getConfig();
        String playerTemplate = config.discordPlayerDeathNameStyle().replace("{player}", components.diedEntityName().getString());
        String killerTemplate = config.discordPlayerDeathSecondEntityStyle().replace("{second_entity}", components.killerEntity() == null ? "" : components.killerEntity().getString());
        String weaponTemplate = config.discordPlayerDeathWeaponStyle().replace("{item}", components.item() == null ? "" : components.item().getString());
        return config.discordPlayerDeathCauseStyle().replace("{death_cause}", components.deathCause().getString().replace("{died.entity}", playerTemplate).replace("{second.entity}", killerTemplate).replace("{item}", weaponTemplate));
    }

    public static Map<String, String> buildPlayerParameters(CommandSourceStack source2) {
        return source2.getPlayer() == null ? DiscordChatStyleProvider.buildPlayerParameters(source2.getDisplayName().getString(), null) : DiscordChatStyleProvider.buildPlayerParameters(source2.getDisplayName().getString(), source2.getEntity());
    }

    public static Map<String, String> buildPlayerParameters(Entity entity) {
        return DiscordChatStyleProvider.buildPlayerParameters(entity.getDisplayName().getString(), entity);
    }

    public static Map<String, String> buildPlayerParameters(String displayName, Entity entity) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("{player}", displayName);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            result.put("{player_avatar_url}", WebhookUtils.getPlayerAvatarUrl(player));
        } else {
            result.put("{player_avatar_url}", ConfigProvider.getConfig().webhookServerAvatarUrl());
        }
        return result;
    }

    public static Optional<DiscordMessageComponents> getDiscordMessageComponents(MessageType messageType, Map<String, String> parameterMap) {
        IConfigProvider config = ConfigProvider.getConfig();
        OffsetDateTime now = ChatStyleUtils.getDateTimeWithUtcOffset();
        parameterMap = ChatStyleUtils.mergeMaps(parameterMap, Map.of("{timestamp}", String.valueOf(now.toEpochSecond())), Map.of("{datetime}", now.format(DateTimeFormatter.ISO_INSTANT)));
        try {
            DiscordMessageComponents result = switch (messageType) {
                default -> throw new MatchException(null, null);
                case MessageType.PINNED_STATUS_AVAILABLE -> DiscordChatStyleProvider.parseDiscordConfigTemplate(ChatStyleUtils.setConfigTemplateTranslatableParameters(config.discordPinnedStatusMessageServerAvailableStyle(), "discord_chat_mod.server.status.available"), parameterMap);
                case MessageType.PINNED_STATUS_UNAVAILABLE -> DiscordChatStyleProvider.parseDiscordConfigTemplate(ChatStyleUtils.setConfigTemplateTranslatableParameters(config.discordPinnedStatusMessageServerUnavailableStyle(), "discord_chat_mod.server.status.unavailable"), parameterMap);
                case MessageType.PINNED_STATUS_PLAYERS -> DiscordChatStyleProvider.parseDiscordConfigTemplate(config.discordPinnedStatusMessageStyle(), parameterMap);
                case MessageType.SERVER_START -> DiscordChatStyleProvider.parseDiscordConfigTemplate(ChatStyleUtils.setConfigTemplateTranslatableParameters(config.discordServerStartedMessageStyle(), "discord_chat_mod.server.started"), parameterMap);
                case MessageType.LOCAL_SERVER_START -> DiscordChatStyleProvider.parseDiscordConfigTemplate(config.discordLocalServerStartedMessageStyle(), parameterMap);
                case MessageType.SERVER_STOP -> DiscordChatStyleProvider.parseDiscordConfigTemplate(ChatStyleUtils.setConfigTemplateTranslatableParameters(config.discordServerClosedMessageStyle(), "discord_chat_mod.server.closed"), parameterMap);
                case MessageType.CHAT -> DiscordChatStyleProvider.parseDiscordConfigTemplate(config.discordPlayerMessageStyle(), parameterMap);
                case MessageType.CHAT_WEBHOOK -> DiscordChatStyleProvider.parseDiscordConfigTemplate(config.discordPlayerMessageWebhookStyle(), parameterMap);
                case MessageType.SCREENSHOT -> DiscordChatStyleProvider.parseDiscordConfigTemplate(config.discordScreenshotMessageStyle(), parameterMap);
                case MessageType.SCREENSHOT_WEBHOOK -> DiscordChatStyleProvider.parseDiscordConfigTemplate(config.discordScreenshotMessageWebhookStyle(), parameterMap);
                case MessageType.LEFT -> DiscordChatStyleProvider.parseDiscordConfigTemplate(ChatStyleUtils.setConfigTemplateTranslatableParameters(config.discordPlayerLeftStyle(), "multiplayer.player.left"), parameterMap);
                case MessageType.JOIN -> DiscordChatStyleProvider.parseDiscordConfigTemplate(ChatStyleUtils.setConfigTemplateTranslatableParameters(config.discordPlayerJoinedStyle(), "multiplayer.player.joined"), parameterMap);
                case MessageType.DEATH, MessageType.PET_DEATH -> DiscordChatStyleProvider.parseDiscordConfigTemplate(config.discordPlayerDeathMessageStyle(), parameterMap);
                case MessageType.ADVANCEMENT_GOAL -> DiscordChatStyleProvider.parseDiscordConfigTemplate(ChatStyleUtils.setConfigTemplateTranslatableParameters(config.discordPlayerAdvancementGoalStyle(), "chat.type.advancement.goal"), parameterMap);
                case MessageType.ADVANCEMENT_TASK -> DiscordChatStyleProvider.parseDiscordConfigTemplate(ChatStyleUtils.setConfigTemplateTranslatableParameters(config.discordPlayerAdvancementTaskStyle(), "chat.type.advancement.task"), parameterMap);
                case MessageType.ADVANCEMENT_CHALLENGE -> DiscordChatStyleProvider.parseDiscordConfigTemplate(ChatStyleUtils.setConfigTemplateTranslatableParameters(config.discordPlayerAdvancementChallengeStyle(), "chat.type.advancement.challenge"), parameterMap);
                case MessageType.SAY_COMMAND -> DiscordChatStyleProvider.parseDiscordConfigTemplate(config.discordSayCommandStyle(), parameterMap);
                case MessageType.ME_COMMAND -> DiscordChatStyleProvider.parseDiscordConfigTemplate(config.discordMeCommandStyle(), parameterMap);
                case MessageType.ME_COMMAND_WEBHOOK -> DiscordChatStyleProvider.parseDiscordConfigTemplate(config.discordMeCommandWebhookStyle(), parameterMap);
                case MessageType.TELLRAW_COMMAND -> DiscordChatStyleProvider.parseDiscordConfigTemplate(config.discordTellrawCommandStyle(), parameterMap);
            };
            return Optional.of(result);
        }
        catch (Exception e) {
            LOGGER.error("Error parsing discord message style for message type [{}]", (Object)messageType);
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public record DiscordMessageComponents(Optional<String> content, Optional<MessageEmbed> embed) {
        public boolean hasContentAndEmbed() {
            return this.content.isPresent() && this.embed.isPresent();
        }

        public boolean hasNoEmbed() {
            return this.content.isPresent() && this.embed.isEmpty();
        }

        @Nullable
        public String getContent() {
            return this.content.orElse(null);
        }

        @Nullable
        public MessageEmbed getEmbed() {
            return this.embed.orElse(null);
        }
    }
}

