/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.discord.model;

import org.jetbrains.annotations.Nullable;

public enum ChannelCategory {
    PINNED_STATUS("pinnedStatusMessageChannelId"),
    DEATHS("deathsChannelId"),
    ADVANCEMENTS("advancementsChannelId"),
    SERVER_START_STOP("serverStartStopChannelId"),
    PLAYER_JOIN_LEAVE("playerJoinLeaveChannelId"),
    PLAYER_CHAT("playerChatMessagesChannelId"),
    SCREENSHOTS("screenshotsChannelId"),
    TELLRAW_COMMAND("tellrawChannelId"),
    SAY_COMMAND("sayChannelId"),
    ME_COMMAND("meChannelId");

    private final String configName;

    private ChannelCategory(String configName) {
        this.configName = configName;
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getConfigComment() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> " Overrides the default channel for pinned server status message. If empty, uses defaultChannelId.";
            case 1 -> " Overrides the default channel for player death messages. If empty, uses defaultChannelId.\n Specify \"-1\" to disable sending death messages to Discord";
            case 2 -> " Overrides the default channel for player advancement messages. If empty, uses defaultChannelId.\n Specify \"-1\" to disable sending player advancement messages to Discord";
            case 3 -> " Overrides the default channel for server started/closed messages. If empty, uses defaultChannelId.\n Specify \"-1\" to disable sending server started/closed messages to Discord";
            case 4 -> " Overrides the default channel for player join/leave messages. If empty, uses defaultChannelId.\n Specify \"-1\" to disable sending player join/leave messages to Discord";
            case 5 -> " Overrides the default channel for messages from players in Minecraft chat. If empty, uses defaultChannelId.\n Specify \"-1\" to disable sending messages from Minecraft players chat to Discord";
            case 6 -> " Overrides the default channel for screenshots sent from Minecraft. If empty, uses defaultChannelId.\n Specify \"-1\" to disable sending screenshots from Minecraft to Discord";
            case 7 -> " Overrides the default channel for messages sent using /tellraw @a command. If empty, uses defaultChannelId.\n Specify \"-1\" to disable sending messages sent using /tellraw @a command to Discord";
            case 8 -> " Overrides the default channel for messages sent using /say command. If empty, uses defaultChannelId.\n Specify \"-1\" to disable sending messages send using /say command to Discord";
            case 9 -> " Overrides the default channel for messages sent using /me command. If empty, uses defaultChannelId.\n Specify \"-1\" to disable sending messages send using /me command to Discord";
        };
    }

    @Nullable
    public static ChannelCategory fromConfigName(String name) {
        for (ChannelCategory cat : ChannelCategory.values()) {
            if (!cat.configName.equalsIgnoreCase(name)) continue;
            return cat;
        }
        return null;
    }
}

