/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.discord.model;

import com.denisnumb.discord_chat_mod.discord.DiscordChannelRegistry;
import com.denisnumb.discord_chat_mod.discord.model.ChannelCategory;
import com.shadow.net.dv8tion.jda.api.entities.Guild;
import com.shadow.net.dv8tion.jda.api.entities.Webhook;
import com.shadow.net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class DiscordGuildContext {
    public final Guild guild;
    public GuildMessageChannel defaultChannel;
    public final boolean enablePinnedStatusMessage;
    public final boolean duplicateMessages;
    private final Map<ChannelCategory, @Nullable GuildMessageChannel> channels = new EnumMap<ChannelCategory, GuildMessageChannel>(ChannelCategory.class);
    private final Map<GuildMessageChannel, Webhook> webhooks = new HashMap<GuildMessageChannel, Webhook>();
    public final Map<String, @Nullable GuildMessageChannel> CHANNEL_CACHE = new HashMap<String, GuildMessageChannel>();

    public DiscordGuildContext(Guild guild, boolean duplicateMessages, boolean enablePinnedStatusMessage) {
        this.guild = guild;
        this.duplicateMessages = duplicateMessages;
        this.enablePinnedStatusMessage = enablePinnedStatusMessage;
    }

    public void setChannel(ChannelCategory category, @Nullable GuildMessageChannel channel) {
        this.channels.put(category, channel);
    }

    @Nullable
    public GuildMessageChannel getChannel(ChannelCategory category) {
        return this.channels.getOrDefault((Object)category, this.defaultChannel);
    }

    public GuildMessageChannel getDefaultChannelIfCategoryDisabled(ChannelCategory category) {
        GuildMessageChannel categoryChannel = this.getChannel(category);
        if (DiscordChannelRegistry.isChannelCategoryDisabled(categoryChannel)) {
            return this.defaultChannel;
        }
        return categoryChannel;
    }

    public Guild getGuild() {
        return this.guild;
    }

    public GuildMessageChannel getDefaultChannel() {
        return this.defaultChannel;
    }

    public GuildMessageChannel setDefaultChannel(@Nullable GuildMessageChannel defaultChannel) throws IllegalStateException {
        if (defaultChannel == null) {
            throw new IllegalStateException();
        }
        this.defaultChannel = defaultChannel;
        return defaultChannel;
    }

    public Optional<Webhook> getWebhook(GuildMessageChannel channel) {
        return Optional.ofNullable(this.webhooks.get(channel));
    }

    public void registerWebhook(GuildMessageChannel channel, Webhook webhook) {
        this.webhooks.put(channel, webhook);
    }
}

