/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.markdown;

import com.denisnumb.discord_chat_mod.ColorUtils;
import com.denisnumb.discord_chat_mod.markdown.MarkdownParser;
import com.denisnumb.discord_chat_mod.markdown.MarkdownPattern;
import com.denisnumb.discord_chat_mod.markdown.MarkdownStyle;
import com.denisnumb.discord_chat_mod.markdown.MarkdownToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class MarkdownEditBoxParser
extends MarkdownParser {
    public static List<MarkdownToken> parseMarkdown(String rawText) {
        Matcher matcher;
        ArrayList<MarkdownToken> tokens = new ArrayList<MarkdownToken>();
        rawText = MarkdownEditBoxParser.replaceDoubleSpecialCharacters(rawText);
        for (int currentPos = 0; currentPos < rawText.length(); currentPos += matcher.end()) {
            List<MarkdownToken> innerTokens;
            MarkdownToken token;
            matcher = null;
            MarkdownStyle style = null;
            for (Map.Entry<Pattern, MarkdownStyle> entry : MarkdownPattern.withStyle.entrySet()) {
                Pattern pattern = entry.getKey();
                MarkdownStyle currentStyle = entry.getValue();
                Matcher currentMatcher = pattern.matcher(rawText.substring(currentPos));
                if (!currentMatcher.find() || matcher != null && (MarkdownPattern.isStyleExceptAnother(style, currentStyle) && matcher.start() == currentMatcher.start() || matcher.start() < currentMatcher.start())) continue;
                matcher = currentMatcher;
                style = currentStyle;
            }
            if (matcher == null) {
                MarkdownEditBoxParser.addTextPart(tokens, rawText.substring(currentPos));
                break;
            }
            MarkdownEditBoxParser.addTextPart(tokens, rawText.substring(currentPos, currentPos + matcher.start()));
            String matchedText = matcher.group(0);
            String innerText = matcher.groupCount() > 0 ? matcher.group(1) : null;
            String linkString = null;
            String colorString = null;
            switch (style) {
                case URL: {
                    token = new MarkdownToken(matchedText);
                    token.url = matchedText;
                    break;
                }
                case LINK: {
                    token = new MarkdownToken(matchedText, innerText);
                    linkString = token.url = matcher.group(2);
                    break;
                }
                case DISCORD_MENTION: {
                    token = new MarkdownToken(matchedText);
                    token.isMention = true;
                    break;
                }
                case EMOJI: {
                    token = new MarkdownToken(matchedText);
                    break;
                }
                case COLOR_RANGE: 
                case COLOR_SINGLE: 
                case COLOR_OPEN: {
                    Integer parsedColor = ColorUtils.parseColor(matcher.group(1));
                    String coloredText = matcher.group(2);
                    if (parsedColor != null && !coloredText.isBlank()) {
                        token = new MarkdownToken(matchedText, coloredText);
                        token.color = parsedColor;
                        colorString = matcher.group(1);
                        break;
                    }
                    token = new MarkdownToken(matchedText);
                    break;
                }
                default: {
                    token = new MarkdownToken(matchedText, innerText);
                    MarkdownEditBoxParser.setTokenStyles(token, style);
                }
            }
            if (!token.rawText.equals(token.text) && !(innerTokens = MarkdownEditBoxParser.parseInnerTokens(token)).isEmpty()) {
                token.setInnerTokens(innerTokens);
            }
            MarkdownEditBoxParser.addSpecialCharactersToken(tokens, style, colorString, linkString, false);
            MarkdownEditBoxParser.addToken(tokens, token);
            MarkdownEditBoxParser.addSpecialCharactersToken(tokens, style, colorString, linkString, true);
        }
        return tokens.stream().toList();
    }

    protected static List<MarkdownToken> parseInnerTokens(MarkdownToken token) {
        return MarkdownEditBoxParser.parseMarkdown(token.text).stream().filter(t -> !t.hasNoMarkdown()).toList();
    }

    private static void addSpecialCharactersToken(ArrayList<MarkdownToken> tokens, MarkdownStyle style, @Nullable String colorString, String linkString, boolean isClosing) {
        MarkdownToken token = null;
        switch (style) {
            case UNDERLINED_ITALIC: {
                token = new MarkdownToken("___");
                break;
            }
            case BOLD_ITALIC: {
                token = new MarkdownToken("***");
                break;
            }
            case ITALIC_underline: {
                token = new MarkdownToken("_");
                break;
            }
            case ITALIC_star: {
                token = new MarkdownToken("*");
                break;
            }
            case UNDERLINED: {
                token = new MarkdownToken("__");
                break;
            }
            case BOLD: {
                token = new MarkdownToken("**");
                break;
            }
            case STRIKETHROUGH: {
                token = new MarkdownToken("~~");
                break;
            }
            case OBFUSCATED: {
                token = new MarkdownToken("||");
                break;
            }
            case LINK: {
                token = isClosing ? new MarkdownToken(String.format("](%s)", linkString)) : new MarkdownToken("[");
                break;
            }
            case COLOR_RANGE: {
                if (colorString == null) break;
                token = isClosing ? new MarkdownToken(String.format("<%s/>", colorString)) : new MarkdownToken(String.format("<%s>", colorString));
                break;
            }
            case COLOR_SINGLE: {
                if (isClosing || colorString == null) break;
                token = new MarkdownToken(String.format("<%s/>", colorString));
                break;
            }
            case COLOR_OPEN: {
                if (isClosing || colorString == null) break;
                token = new MarkdownToken(String.format("<%s>", colorString));
            }
        }
        if (token != null) {
            token.color = 0x696969;
            token.isSpecialCharacters = true;
            MarkdownEditBoxParser.addToken(tokens, token);
        }
    }

    protected static void addTextPart(ArrayList<MarkdownToken> tokens, String textPart) {
        if (!textPart.isEmpty()) {
            MarkdownEditBoxParser.addToken(tokens, new MarkdownToken(textPart));
        }
    }

    protected static void addToken(ArrayList<MarkdownToken> tokens, MarkdownToken token) {
        token.text = MarkdownEditBoxParser.replaceDoubleSpecialCharactersBack(token.text);
        token.rawText = MarkdownEditBoxParser.replaceDoubleSpecialCharactersBack(token.rawText);
        tokens.add(token);
    }
}

