/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.markdown;

import com.denisnumb.discord_chat_mod.ColorUtils;
import com.denisnumb.discord_chat_mod.markdown.MarkdownPattern;
import com.denisnumb.discord_chat_mod.markdown.MarkdownStyle;
import com.denisnumb.discord_chat_mod.markdown.MarkdownToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class MarkdownParser {
    private static final Pattern[] colorTagPatterns = new Pattern[]{MarkdownPattern.COLOR_RANGE, MarkdownPattern.COLOR_SINGLE, MarkdownPattern.COLOR_OPEN};

    public static String removeColorTags(String text) {
        for (Pattern pattern : colorTagPatterns) {
            Matcher matcher = pattern.matcher(text);
            while (matcher.find()) {
                String coloredText = matcher.group(2);
                if (ColorUtils.parseColor(matcher.group(1)) == null || coloredText.isBlank()) continue;
                text = text.replace(matcher.group(0), coloredText);
            }
        }
        return text;
    }

    public static List<MarkdownToken> parseMarkdown(String rawText) {
        Matcher matcher;
        ArrayList<MarkdownToken> tokens = new ArrayList<MarkdownToken>();
        rawText = MarkdownParser.replaceDoubleSpecialCharacters(rawText);
        for (int currentPos = 0; currentPos < rawText.length(); currentPos += matcher.end()) {
            List<MarkdownToken> innerTokens;
            MarkdownToken token;
            matcher = null;
            Enum style = null;
            for (Map.Entry<Pattern, MarkdownStyle> entry : MarkdownPattern.withStyle.entrySet()) {
                Pattern pattern = entry.getKey();
                MarkdownStyle currentStyle = entry.getValue();
                Matcher currentMatcher = pattern.matcher(rawText.substring(currentPos));
                if (!currentMatcher.find() || matcher != null && (MarkdownPattern.isStyleExceptAnother((MarkdownStyle)style, currentStyle) && matcher.start() == currentMatcher.start() || matcher.start() < currentMatcher.start())) continue;
                matcher = currentMatcher;
                style = currentStyle;
            }
            if (matcher == null) {
                MarkdownParser.addTextPart(tokens, rawText.substring(currentPos));
                break;
            }
            MarkdownParser.addTextPart(tokens, rawText.substring(currentPos, currentPos + matcher.start()));
            String matchedText = matcher.group(0);
            String innerText = matcher.groupCount() > 0 ? matcher.group(1) : null;
            switch (1.$SwitchMap$com$denisnumb$discord_chat_mod$markdown$MarkdownStyle[style.ordinal()]) {
                case 1: {
                    token = new MarkdownToken(matchedText);
                    token.url = matchedText;
                    break;
                }
                case 2: {
                    token = new MarkdownToken(matchedText, innerText);
                    token.url = matcher.group(2);
                    break;
                }
                case 3: {
                    token = new MarkdownToken(matchedText);
                    token.isMention = true;
                    break;
                }
                case 4: {
                    token = new MarkdownToken(matchedText);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    Integer parsedColor = ColorUtils.parseColor(matcher.group(1));
                    String coloredText = matcher.group(2);
                    if (parsedColor != null && !coloredText.isBlank()) {
                        token = new MarkdownToken(matchedText, coloredText);
                        token.color = parsedColor;
                        break;
                    }
                    token = new MarkdownToken(matchedText);
                    break;
                }
                default: {
                    token = new MarkdownToken(matchedText, innerText);
                    MarkdownParser.setTokenStyles(token, (MarkdownStyle)style);
                }
            }
            if (!token.rawText.equals(token.text) && !(innerTokens = MarkdownParser.parseInnerTokens(token)).isEmpty()) {
                token.setInnerTokens(innerTokens);
            }
            MarkdownParser.addToken(tokens, token);
        }
        return tokens.stream().toList();
    }

    protected static List<MarkdownToken> parseInnerTokens(MarkdownToken token) {
        return MarkdownParser.parseMarkdown(token.text).stream().filter(t -> !t.hasNoMarkdown()).toList();
    }

    protected static void setTokenStyles(MarkdownToken token, MarkdownStyle style) {
        switch (style) {
            case UNDERLINED_ITALIC: {
                token.underlined = true;
                token.italic = true;
                break;
            }
            case BOLD_ITALIC: {
                token.bold = true;
                token.italic = true;
                break;
            }
            case ITALIC_underline: 
            case ITALIC_star: {
                token.italic = true;
                break;
            }
            case UNDERLINED: {
                token.underlined = true;
                break;
            }
            case BOLD: {
                token.bold = true;
                break;
            }
            case STRIKETHROUGH: {
                token.strikethrough = true;
                break;
            }
            case OBFUSCATED: {
                token.obfuscated = true;
            }
        }
    }

    protected static void addToken(ArrayList<MarkdownToken> tokens, MarkdownToken token) {
        token.text = MarkdownParser.replaceDoubleSpecialCharactersBack(MarkdownParser.unescapeSpecialCharacters(token.text));
        token.rawText = MarkdownParser.replaceDoubleSpecialCharactersBack(MarkdownParser.unescapeSpecialCharacters(token.rawText));
        tokens.add(token);
    }

    protected static void addTextPart(ArrayList<MarkdownToken> tokens, String textPart) {
        if (!textPart.isEmpty()) {
            MarkdownParser.addToken(tokens, new MarkdownToken(textPart));
        }
    }

    protected static String unescapeSpecialCharacters(String text) {
        return text.replaceAll("\\\\([*_~|@><])", "$1");
    }

    protected static String replaceDoubleSpecialCharacters(String text) {
        return text.replaceAll("__(.+?)_(.+?)___", "\u25ba$1_$2_\u25ba").replaceAll("___(.+?)_(.+?)__", "\u25ba_$1_$2\u25ba").replaceAll("\\*\\*(.+?)\\*(.+?)\\*\\*\\*", "\u25ac$1*$2*\u25ac").replaceAll("\\*\\*\\*(.+?)\\*(.+?)\\*\\*", "\u25ac*$1*$2\u25ac").replaceAll("(?<!\\\\)_{3}(.+?)(?<!\\\\)_{3}", "\u25ba_$1_\u25ba").replaceAll("(?<!\\\\)\\*{3}(.+?)(?<!\\\\)\\*{3}", "\u25ac*$1*\u25ac").replaceAll("(?<!\\\\)\\*{2}(.+?)(?<!\\\\)\\*{2}", "\u25ac$1\u25ac").replaceAll("(?<!\\\\)_{2}(.+?)(?<!\\\\)_{2}", "\u25ba$1\u25ba");
    }

    protected static String replaceDoubleSpecialCharactersBack(String text) {
        return text.replace("\u25ac", "**").replace("\u25ba", "__");
    }
}

