/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.mixin;

import com.denisnumb.discord_chat_mod.LocaleProvider;
import com.denisnumb.discord_chat_mod.MinecraftClientEvents;
import com.denisnumb.discord_chat_mod.chat_images.ImageStorage;
import com.denisnumb.discord_chat_mod.chat_images.model.AbstractImage;
import com.denisnumb.discord_chat_mod.chat_images.model.AnimatedImage;
import com.denisnumb.discord_chat_mod.chat_images.model.Image;
import com.denisnumb.discord_chat_mod.chat_images.model.ImageSize;
import com.denisnumb.discord_chat_mod.config.ConfigProvider;
import com.google.common.collect.Lists;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChatComponent.class})
public abstract class ChatComponentMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Final
    private List<GuiMessage.Line> trimmedMessages;
    @Shadow
    private int chatScrollbarPos;
    @Shadow
    @Final
    private List<GuiMessage> allMessages;

    @Shadow
    protected abstract int getLineHeight();

    @Shadow
    public abstract boolean isChatFocused();

    @Shadow
    public abstract double getScale();

    @Shadow
    public abstract int getLinesPerPage();

    @ModifyArg(method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;Lnet/minecraft/client/GuiMessageTag;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/GuiMessage;<init>(ILnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;Lnet/minecraft/client/GuiMessageTag;)V"), index=1, require=0)
    private Component handleChatMessageClient(Component component) {
        return MinecraftClientEvents.handleChatMessage(component);
    }

    @Unique
    private List<String> discord_minecraft_chat$getComponentUrls(Component component) {
        return component.toFlatList().stream().filter(comp -> {
            ClickEvent clickEvent = comp.getStyle().getClickEvent();
            return clickEvent != null && clickEvent.getAction() == ClickEvent.Action.OPEN_URL;
        }).map(comp -> comp.getStyle().getClickEvent().getValue()).toList();
    }

    @Unique
    private int discord_minecraft_chat$getImageLinesCount(int imageHeight) {
        return Mth.ceil((float)((float)imageHeight / (float)this.getLineHeight())) + 1;
    }

    @Unique
    private int discord_minecraft_chat$getGuiMessageIndexByTrimmedMessageIndex(int targetIndex) {
        int messageIndex = -1;
        for (int i = 0; i <= targetIndex; ++i) {
            if (!this.trimmedMessages.get(i).endOfEntry()) continue;
            ++messageIndex;
        }
        return messageIndex;
    }

    @Inject(method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;Lnet/minecraft/client/GuiMessageTag;)V"}, at={@At(value="TAIL")})
    private void addMessage(Component chatComponent, MessageSignature headerSignature, GuiMessageTag tag, CallbackInfo ci, @Local GuiMessage guimessage) {
        List<String> componentUrls = this.discord_minecraft_chat$getComponentUrls(chatComponent);
        if (componentUrls.isEmpty()) {
            return;
        }
        ImageStorage.loadImagesParallel(componentUrls, () -> this.trimmedMessages.size(), () -> this.allMessages.size()).thenAccept(loadResult -> {
            int oldTrimmedSize = loadResult.trimmedMessagesSize();
            int oldAllSize = loadResult.allMessagesSize();
            int trimmedIndex = this.trimmedMessages.size() > oldTrimmedSize ? this.trimmedMessages.size() - oldTrimmedSize : 0;
            int allIndex = this.allMessages.size() > oldAllSize ? this.allMessages.size() - oldAllSize : 0;
            for (AbstractImage image : Lists.reverse(loadResult.images())) {
                int i;
                if (image == null) continue;
                int linesCount = this.discord_minecraft_chat$getImageLinesCount(image.imageSize.height());
                MutableComponent imageComponent = Component.literal((String)" ".repeat(image.imageSize.width() / this.minecraft.font.width(" "))).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)LocaleProvider.getTranslateClient("discord_chat_mod.command.click_to_open_image")))).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "open_image " + image.url)));
                FormattedCharSequence imageCharSequence = imageComponent.getVisualOrderText();
                for (i = 0; i < linesCount; ++i) {
                    this.trimmedMessages.add(trimmedIndex, new GuiMessage.Line(guimessage.addedTime(), imageCharSequence, tag, true));
                }
                trimmedIndex += linesCount;
                for (i = 0; i < linesCount; ++i) {
                    this.allMessages.add(allIndex, new GuiMessage(guimessage.addedTime(), (Component)imageComponent, headerSignature, tag));
                }
                allIndex += linesCount;
            }
        });
    }

    @ModifyConstant(method={"addMessageToQueue(Lnet/minecraft/client/GuiMessage;)V"}, constant={@Constant(intValue=100)}, require=0)
    private int modifyAddMessageToQueueMessageLimit(int original) {
        return ConfigProvider.getConfig().maxChatHistory();
    }

    @ModifyConstant(method={"addMessageToDisplayQueue(Lnet/minecraft/client/GuiMessage;)V"}, constant={@Constant(intValue=100)}, require=0)
    private int modifyAddMessageToDisplayQueueMessageLimit(int original) {
        return ConfigProvider.getConfig().maxChatHistory();
    }

    @Inject(method={"addMessageToQueue(Lnet/minecraft/client/GuiMessage;)V"}, at={@At(value="INVOKE", target="Ljava/util/List;add(ILjava/lang/Object;)V", shift=At.Shift.AFTER)})
    private void removeOldFromAllMessages(GuiMessage message, CallbackInfo ci) {
        while (this.allMessages.size() > ConfigProvider.getConfig().maxChatHistory()) {
            int parentAddedTime = this.allMessages.getLast().addedTime();
            do {
                this.allMessages.removeLast();
            } while (this.allMessages.getLast().addedTime() == parentAddedTime);
        }
    }

    @Inject(method={"addMessageToDisplayQueue(Lnet/minecraft/client/GuiMessage;)V"}, at={@At(value="INVOKE", target="Ljava/util/List;add(ILjava/lang/Object;)V", shift=At.Shift.BY, by=2)})
    private void removeOldFromTrimmedMessages(GuiMessage message, CallbackInfo ci) {
        while (this.trimmedMessages.size() > ConfigProvider.getConfig().maxChatHistory()) {
            int parentAddedTime = this.trimmedMessages.getLast().addedTime();
            do {
                this.trimmedMessages.removeLast();
            } while (this.trimmedMessages.getLast().addedTime() == parentAddedTime);
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIIZ)V"}, at={@At(value="TAIL")})
    private void render(GuiGraphics graphics, int tickCount, int mouseX, int mouseY, boolean focused, CallbackInfo ci) {
        HashMap<Integer, List<String>> allChatUrls = new HashMap<Integer, List<String>>();
        for (int i = 0; i < this.allMessages.size(); ++i) {
            GuiMessage guiMessage = this.allMessages.get(i);
            List<String> urls2 = this.discord_minecraft_chat$getComponentUrls(guiMessage.content());
            if (urls2.isEmpty()) continue;
            allChatUrls.put(i, urls2);
        }
        if (allChatUrls.isEmpty()) {
            return;
        }
        int chatBottomY = Mth.floor((float)((float)(graphics.guiHeight() - 40) / (float)this.getScale()));
        int lineHeight = this.getLineHeight();
        int chatTopY = chatBottomY - lineHeight * this.getLinesPerPage();
        boolean isChatFocused = this.isChatFocused();
        HashMap<Integer, Integer> messagesY = new HashMap<Integer, Integer>();
        int i = 0;
        while (i + this.chatScrollbarPos < this.trimmedMessages.size()) {
            int messageIndex = i + this.chatScrollbarPos;
            int guiMessageIndex = this.discord_minecraft_chat$getGuiMessageIndexByTrimmedMessageIndex(messageIndex);
            int messageY = chatBottomY - i * lineHeight;
            if (this.trimmedMessages.get(messageIndex).endOfEntry()) {
                messagesY.put(guiMessageIndex, messageY);
            }
            ++i;
        }
        graphics.pose().pushPose();
        graphics.pose().translate(4.0f, 0.0f, 50.0f);
        for (Map.Entry entry : allChatUrls.entrySet()) {
            int messageIndex = (Integer)entry.getKey();
            GuiMessage guiMessage = this.allMessages.get(messageIndex);
            List urls3 = (List)entry.getValue();
            if (!messagesY.containsKey(messageIndex) || tickCount - guiMessage.addedTime() >= 200 && !isChatFocused) continue;
            int messageY = (Integer)messagesY.get(messageIndex);
            int offset = 0;
            for (String imageUrl : urls3) {
                int endY;
                int imageHeight;
                ResourceLocation resourceLocation;
                if (!ImageStorage.IMAGE_CACHE.containsKey(imageUrl)) continue;
                AbstractImage abstractImage = ImageStorage.IMAGE_CACHE.get(imageUrl);
                ImageSize imageSize = abstractImage.imageSize;
                if (abstractImage.isSpoilerAndNotOpened()) {
                    resourceLocation = abstractImage.spoilerResourceLocation;
                } else if (abstractImage instanceof AnimatedImage) {
                    AnimatedImage gif = (AnimatedImage)abstractImage;
                    resourceLocation = gif.getCurrentFrame();
                } else {
                    resourceLocation = ((Image)abstractImage).resourceLocation;
                }
                ResourceLocation resourceLocation2 = resourceLocation;
                int imageWidth = imageSize.width();
                int visibleHeight = imageHeight = imageSize.height();
                int startY = messageY + offset + lineHeight / 2;
                int startV = 0;
                if (startY < chatTopY) {
                    startV = Math.abs(chatTopY - startY);
                    visibleHeight -= startV;
                    startY = chatTopY;
                }
                if ((endY = startY + imageHeight) > chatBottomY) {
                    visibleHeight -= Math.abs(endY - chatBottomY);
                }
                graphics.blit(resourceLocation2, 0, startY, 0.0f, (float)startV, imageWidth, visibleHeight, imageWidth, imageHeight);
                if (abstractImage.isSpoilerAndNotOpened()) {
                    MutableComponent spoilerText = Component.literal((String)LocaleProvider.getTranslateClient("discord_chat_mod.spoiler")).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
                    float maxScale = 1.5f;
                    float scaleX = (float)imageWidth / 128.0f * maxScale;
                    float scaleY = (float)imageHeight / 72.0f * maxScale;
                    float scale = Mth.clamp((float)Math.min(scaleX, scaleY), (float)0.5f, (float)maxScale);
                    int originalTextWidth = this.minecraft.font.width((FormattedText)spoilerText);
                    Objects.requireNonNull(this.minecraft.font);
                    int originalTextHeight = 9;
                    int centerX = imageWidth / 2;
                    int fullCenterY = messageY + offset + lineHeight / 2 + imageHeight / 2;
                    if (fullCenterY >= chatTopY && fullCenterY <= chatBottomY) {
                        int textX = centerX - (int)((float)originalTextWidth * scale / 2.0f);
                        int textY = fullCenterY - (int)((float)originalTextHeight * scale / 2.0f);
                        graphics.pose().pushPose();
                        graphics.pose().translate((float)textX, (float)textY, 0.0f);
                        graphics.pose().scale(scale, scale, 1.0f);
                        graphics.drawString(this.minecraft.font, (Component)spoilerText, 0, 0, 0xFFFFFF, true);
                        graphics.pose().popPose();
                    }
                }
                offset += imageHeight + lineHeight;
            }
        }
        graphics.pose().popPose();
    }
}

