/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.mixin;

import com.denisnumb.discord_chat_mod.markdown.MarkdownEditBoxParser;
import com.denisnumb.discord_chat_mod.markdown.MarkdownToComponentConverter;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EditBox.class})
public abstract class EditBoxMixin {
    @Shadow
    @Final
    private Font font;
    @Shadow
    private String value;
    @Shadow
    private int displayPos;
    @Shadow
    private int cursorPos;
    @Unique
    private FormattedCharSequence discord_chat_mod$cachedMarkdown = null;
    @Unique
    private boolean discord_chat_mod$markdownValid = false;
    @Unique
    private String discord_chat_mod$lastInput = "";

    @Shadow
    public abstract int getInnerWidth();

    @Unique
    private static FormattedCharSequence discord_minecraft_chat$substringFormatted(FormattedCharSequence text, int start, int end) {
        if (start >= end || start < 0) {
            return FormattedCharSequence.EMPTY;
        }
        ArrayList parts = new ArrayList();
        AtomicInteger index = new AtomicInteger();
        text.accept((i, style, codePoint) -> {
            if (index.get() >= start && index.get() < end) {
                parts.add(FormattedCharSequence.codepoint((int)codePoint, (Style)style));
            }
            index.getAndIncrement();
            return true;
        });
        return FormattedCharSequence.composite(parts);
    }

    @Inject(method={"renderWidget(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Ljava/lang/String;isEmpty()Z", ordinal=0, shift=At.Shift.AFTER)})
    private void prepareMarkdown(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci, @Local String string) {
        if (!string.isEmpty() && !this.value.startsWith("/")) {
            if (!string.equals(this.discord_chat_mod$lastInput)) {
                this.discord_chat_mod$lastInput = string;
                MutableComponent markdown = new MarkdownToComponentConverter(MarkdownEditBoxParser.parseMarkdown(string)).convertMarkdownTokensWithSpecialCharsToComponent();
                this.discord_chat_mod$markdownValid = markdown.getString().equals(string);
                this.discord_chat_mod$cachedMarkdown = this.discord_chat_mod$markdownValid ? markdown.getVisualOrderText() : null;
            }
        } else {
            this.discord_chat_mod$markdownValid = false;
            this.discord_chat_mod$cachedMarkdown = null;
        }
    }

    @ModifyArg(method={"renderWidget(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/util/FormattedCharSequence;III)I", ordinal=0), require=0)
    public FormattedCharSequence modifyBeforeCursorDrawString(FormattedCharSequence formattedCharSequence) {
        boolean cursorInBounds;
        String currentInput = this.font.plainSubstrByWidth(this.value.substring(this.displayPos), this.getInnerWidth());
        int stringLenBeforeCursor = this.cursorPos - this.displayPos;
        boolean bl = cursorInBounds = stringLenBeforeCursor >= 0 && stringLenBeforeCursor <= currentInput.length();
        return this.discord_chat_mod$markdownValid ? (cursorInBounds ? EditBoxMixin.discord_minecraft_chat$substringFormatted(this.discord_chat_mod$cachedMarkdown, 0, stringLenBeforeCursor) : this.discord_chat_mod$cachedMarkdown) : formattedCharSequence;
    }

    @ModifyArg(method={"renderWidget(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/util/FormattedCharSequence;III)I", ordinal=1), require=0)
    public FormattedCharSequence modifyAfterCursorDrawString(FormattedCharSequence formattedCharSequence) {
        String currentInput = this.font.plainSubstrByWidth(this.value.substring(this.displayPos), this.getInnerWidth());
        int stringLenBeforeCursor = this.cursorPos - this.displayPos;
        return this.discord_chat_mod$markdownValid ? EditBoxMixin.discord_minecraft_chat$substringFormatted(this.discord_chat_mod$cachedMarkdown, stringLenBeforeCursor, currentInput.length()) : formattedCharSequence;
    }
}

