/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.mixin;

import com.denisnumb.discord_chat_mod.chat_images.ImageScreen;
import com.denisnumb.discord_chat_mod.chat_images.ImageStorage;
import com.denisnumb.discord_chat_mod.chat_images.model.AbstractImage;
import com.denisnumb.discord_chat_mod.chat_images.utils.ImageUtils;
import com.denisnumb.discord_chat_mod.network.screenshot.ScreenshotTransceiver;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Screen.class})
public abstract class ScreenMixin {
    @Shadow
    protected Minecraft minecraft;

    @Shadow
    public static boolean hasShiftDown() {
        return false;
    }

    @Inject(method={"handleComponentClicked(Lnet/minecraft/network/chat/Style;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleComponentClicked(Style style, CallbackInfoReturnable<Boolean> cir) {
        ClickEvent clickEvent;
        if (style != null && (clickEvent = style.getClickEvent()) != null) {
            if (clickEvent.getAction() == ClickEvent.Action.OPEN_URL && ImageUtils.isLocalResourceUrl(clickEvent.getValue())) {
                cir.setReturnValue((Object)true);
            }
            if (clickEvent.getAction() == ClickEvent.Action.RUN_COMMAND) {
                String value = StringUtil.filterText((String)clickEvent.getValue());
                if (value.startsWith("send_screenshot")) {
                    boolean sendAsSpoiler = ScreenMixin.hasShiftDown();
                    String filePath = value.replace("send_screenshot ", "");
                    this.discord_minecraft_chat$sendScreenshot(filePath, sendAsSpoiler);
                    cir.setReturnValue((Object)true);
                }
                if (value.startsWith("open_image")) {
                    String imageUrl = value.replace("open_image ", "");
                    AbstractImage image = ImageStorage.IMAGE_CACHE.getOrDefault(imageUrl, null);
                    if (image != null) {
                        if (image.isSpoilerAndNotOpened()) {
                            image.openSpoiler();
                        } else {
                            this.minecraft.setScreen((Screen)new ImageScreen(image));
                        }
                    }
                    cir.setReturnValue((Object)true);
                }
            }
        }
    }

    @Unique
    private void discord_minecraft_chat$sendScreenshot(String filePath, boolean sendAsSpoiler) {
        File screenshotFile = new File(filePath);
        if (screenshotFile.exists() && screenshotFile.isFile() && screenshotFile.getName().endsWith(".png")) {
            ScreenshotTransceiver.sendScreenshotToServer(screenshotFile, (Player)this.minecraft.player, sendAsSpoiler);
        }
    }
}

