/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.mixin.chat_style;

import com.denisnumb.discord_chat_mod.MinecraftEvents;
import com.denisnumb.discord_chat_mod.chat_style.CustomChatTypeRegistry;
import com.denisnumb.discord_chat_mod.chat_style.MinecraftChatStyleProvider;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class ServerGamePacketListenerImplMixin
extends ServerCommonPacketListenerImpl {
    @Shadow
    public ServerPlayer player;

    public ServerGamePacketListenerImplMixin(MinecraftServer minecraftServer, Connection connection, CommonListenerCookie commonListenerCookie) {
        super(minecraftServer, connection, commonListenerCookie);
    }

    @ModifyExpressionValue(method={"lambda$handleChat$6(Lnet/minecraft/network/protocol/game/ServerboundChatPacket;Ljava/util/Optional;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/chat/PlayerChatMessage;decoratedContent()Lnet/minecraft/network/chat/Component;")}, require=0)
    private Component applyMarkdownToMessageText(Component original) {
        return MinecraftEvents.handleChatMessageText(this.player, original);
    }

    @ModifyArg(method={"removePlayerFromWorld()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastSystemMessage(Lnet/minecraft/network/chat/Component;Z)V"), require=0)
    private Component modifyLeftMessage(Component original) {
        return MinecraftEvents.handleJoinLeave((Player)this.player, false).orElse(original);
    }

    @ModifyArgs(method={"broadcastChatMessage(Lnet/minecraft/network/chat/PlayerChatMessage;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastChatMessage(Lnet/minecraft/network/chat/PlayerChatMessage;Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/network/chat/ChatType$Bound;)V"), require=0)
    private void modifyPlayerChatMessage(Args args2) {
        PlayerChatMessage originalMessage = (PlayerChatMessage)args2.get(0);
        Component playerComponent = this.player.getDisplayName();
        Component originalContent = originalMessage.decoratedContent();
        MinecraftEvents.handleChatMessage(CustomChatTypeRegistry.CHAT, new MinecraftChatStyleProvider.ChatMessageComponents(playerComponent, originalContent, null)).ifPresent(styledContent -> {
            ChatType.Bound styledBound = CustomChatTypeRegistry.buildBound(CustomChatTypeRegistry.CHAT, this.player.level().registryAccess(), playerComponent, originalContent);
            args2.set(0, (Object)originalMessage.withUnsignedContent(styledContent));
            args2.set(2, (Object)styledBound);
        });
    }
}

