/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class BigPacketsTransceiver {
    private static final int MAX_PART_SIZE = 32000;

    public static void send(byte[] data, SendFunction sendFunction) {
        int totalParts = (int)Math.ceil((double)data.length / 32000.0);
        for (int i = 0; i < totalParts; ++i) {
            int start = i * 32000;
            int end = Math.min(start + 32000, data.length);
            byte[] part = Arrays.copyOfRange(data, start, end);
            sendFunction.send(i, totalParts, part);
        }
    }

    public static Optional<byte[]> receivePart(Map<Long, ArrayList<byte[]>> receivedParts, long sendTime, int partIndex, int totalParts, byte[] partData) {
        receivedParts.computeIfAbsent(sendTime, t -> new ArrayList<Object>(Collections.nCopies(totalParts, null)));
        receivedParts.get(sendTime).set(partIndex, partData);
        if (receivedParts.get(sendTime).stream().noneMatch(Objects::isNull)) {
            byte[] data = BigPacketsTransceiver.mergeParts(receivedParts.get(sendTime));
            receivedParts.remove(sendTime);
            return Optional.of(data);
        }
        return Optional.empty();
    }

    private static byte[] mergeParts(ArrayList<byte[]> parts) {
        int totalSize = parts.stream().mapToInt(arr -> ((byte[])arr).length).sum();
        byte[] result = new byte[totalSize];
        int offset = 0;
        for (byte[] part : parts) {
            System.arraycopy(part, 0, result, offset, part.length);
            offset += part.length;
        }
        return result;
    }

    @FunctionalInterface
    public static interface SendFunction {
        public void send(int var1, int var2, byte[] var3);
    }
}

