/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.network.mentions;

import com.denisnumb.discord_chat_mod.discord.ChannelMembersProvider;
import com.denisnumb.discord_chat_mod.discord.model.ChannelCategory;
import com.denisnumb.discord_chat_mod.discord.model.DiscordUserData;
import com.denisnumb.discord_chat_mod.network.BigPacketsTransceiver;
import com.denisnumb.discord_chat_mod.network.PlatformPacketDistributor;
import com.denisnumb.discord_chat_mod.network.mentions.DiscordMentionsPartPacket;
import com.denisnumb.discord_chat_mod.network.mentions.RequestDiscordMentionsPacket;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;

public class DiscordMentionsTransceiver {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<Long, ArrayList<byte[]>> receivedParts = new HashMap<Long, ArrayList<byte[]>>();
    private static final Gson gson = new Gson();
    private static final Type gsonType = new TypeToken<List<DiscordUserData>>(){}.getType();
    private static long lastRequestTime = 0L;

    public static void requestDiscordMemberData() {
        long requestTime = System.currentTimeMillis();
        if (requestTime - lastRequestTime < 5000L) {
            return;
        }
        lastRequestTime = requestTime;
        try {
            PlatformPacketDistributor.sendToServer(new RequestDiscordMentionsPacket());
        }
        catch (Exception e) {
            LOGGER.error("RequestDiscordMentionsError: " + e.getMessage());
        }
    }

    public static void sendDiscordMemberDataToPlayer(ServerPlayer player) {
        long sendTime = System.currentTimeMillis();
        byte[] data = gson.toJson(ChannelMembersProvider.getMemberData(ChannelCategory.PLAYER_CHAT), gsonType).getBytes();
        BigPacketsTransceiver.send(data, (partIndex, totalParts, part) -> PlatformPacketDistributor.sendToPlayer(player, new DiscordMentionsPartPacket(sendTime, partIndex, totalParts, part)));
    }

    public static void receiveDiscordMentionsPart(DiscordMentionsPartPacket packet) {
        BigPacketsTransceiver.receivePart(receivedParts, packet.sendTime(), packet.partIndex(), packet.totalParts(), packet.data()).ifPresent(bytes -> {
            ChannelMembersProvider.CLIENT_MEMBER_CACHE = (List)gson.fromJson(new String((byte[])bytes), gsonType);
        });
    }
}

