/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.network.screenshot;

import com.denisnumb.discord_chat_mod.ColorUtils;
import com.denisnumb.discord_chat_mod.DiscordChatMod;
import com.denisnumb.discord_chat_mod.LocaleProvider;
import com.denisnumb.discord_chat_mod.MinecraftUtils;
import com.denisnumb.discord_chat_mod.chat_images.ImageStorage;
import com.denisnumb.discord_chat_mod.chat_style.ChatStyleUtils;
import com.denisnumb.discord_chat_mod.discord.DiscordChannelRegistry;
import com.denisnumb.discord_chat_mod.discord.DiscordUtils;
import com.denisnumb.discord_chat_mod.discord.chat_style.DiscordChatStyleProvider;
import com.denisnumb.discord_chat_mod.discord.chat_style.MessageType;
import com.denisnumb.discord_chat_mod.discord.model.ChannelCategory;
import com.denisnumb.discord_chat_mod.network.BigPacketsTransceiver;
import com.denisnumb.discord_chat_mod.network.PlatformPacketDistributor;
import com.denisnumb.discord_chat_mod.network.screenshot.ScreenshotPartPacket;
import com.google.gson.Gson;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class ScreenshotTransceiver {
    private static final Gson gson = new Gson();
    private static final ExecutorService networkPool = Executors.newSingleThreadExecutor();
    private static final Map<Long, ArrayList<byte[]>> receivedParts = new HashMap<Long, ArrayList<byte[]>>();
    private static long lastSendScreenshotTime = 0L;
    private static File lastFile = null;

    public static void sendScreenshotToServer(File screenshotFile, Player player, boolean sendAsSpoiler) {
        long currentTime = System.currentTimeMillis();
        if (screenshotFile.equals(lastFile) && currentTime - lastSendScreenshotTime < 20000L || currentTime - lastSendScreenshotTime < 2000L) {
            MinecraftUtils.showTitleBarMessage((Component)Component.literal((String)LocaleProvider.getTranslateClient("discord_chat_mod.command.send_screenshot.cooldown")).withColor(ChatFormatting.YELLOW.getColor().intValue()));
            return;
        }
        MinecraftUtils.showTitleBarMessage((Component)Component.literal((String)LocaleProvider.getTranslateClient("discord_chat_mod.command.send_screenshot.sending_screenshot")));
        networkPool.execute(() -> {
            try {
                byte[] screenshotBytes = Files.readAllBytes(screenshotFile.toPath());
                Object fileName = sendAsSpoiler ? "/SPOILER_" + screenshotFile.getName() : screenshotFile.getName();
                byte[] data = gson.toJson((Object)new DiscordUtils.ImageData((String)fileName, screenshotBytes)).getBytes();
                lastFile = screenshotFile;
                lastSendScreenshotTime = currentTime;
                BigPacketsTransceiver.send(data, (partIndex, totalParts, part) -> PlatformPacketDistributor.sendToServer(new ScreenshotPartPacket(currentTime, partIndex, totalParts, part)));
            }
            catch (Exception e) {
                ScreenshotTransceiver.sendErrorMessageToPlayer(player, e.getMessage());
            }
        });
    }

    public static void receivePartClientSide(ScreenshotPartPacket packet) {
        ScreenshotTransceiver.receivePartCommon(packet, ScreenshotTransceiver::handleReceivedScreenshotClient);
    }

    public static void receivePartServerSide(ScreenshotPartPacket packet, ServerPlayer player) {
        ScreenshotTransceiver.receivePartCommon(packet, rawData -> ScreenshotTransceiver.handleReceivedScreenshotServer(rawData, player));
    }

    private static void receivePartCommon(ScreenshotPartPacket packet, Consumer<byte[]> onComplete) {
        BigPacketsTransceiver.receivePart(receivedParts, packet.imageId(), packet.partIndex(), packet.totalParts(), packet.data()).ifPresent(rawData -> networkPool.execute(() -> onComplete.accept((byte[])rawData)));
    }

    private static void handleReceivedScreenshotClient(byte[] rawScreenshotData) {
        DiscordUtils.ImageData screenshotData = (DiscordUtils.ImageData)gson.fromJson(new String(rawScreenshotData), DiscordUtils.ImageData.class);
        try {
            ImageStorage.registerImage(screenshotData.fileName(), screenshotData.data());
        }
        catch (Exception e) {
            DiscordChatMod.LOGGER.error("ClientScreenshotHandleError: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void handleReceivedScreenshotServer(byte[] rawScreenshotData, ServerPlayer player) {
        if (DiscordChatMod.isDiscordConnected()) {
            ScreenshotTransceiver.sendScreenshotToDiscord(rawScreenshotData, player);
            return;
        }
        ScreenshotTransceiver.sendScreenshotToPlayers(rawScreenshotData, player);
    }

    private static void sendScreenshotToPlayers(byte[] rawScreenshotData, ServerPlayer fromPlayer) {
        DiscordUtils.ImageData screenshotData = (DiscordUtils.ImageData)gson.fromJson(new String(rawScreenshotData), DiscordUtils.ImageData.class);
        long currentTime = System.currentTimeMillis();
        String uniqueFilename = "localResource://" + currentTime + "/" + screenshotData.fileName();
        networkPool.execute(() -> {
            try {
                byte[] data = gson.toJson((Object)new DiscordUtils.ImageData(uniqueFilename, screenshotData.data())).getBytes();
                List playerList = Objects.requireNonNull(fromPlayer.getServer()).getPlayerList().getPlayers();
                for (ServerPlayer player : playerList) {
                    try {
                        BigPacketsTransceiver.send(data, (partIndex, totalParts, part) -> PlatformPacketDistributor.sendToPlayer(player, new ScreenshotPartPacket(currentTime, partIndex, totalParts, part)));
                    }
                    catch (Exception exception) {}
                }
                MutableComponent screenshotComponent = Component.literal((String)LocaleProvider.getTranslate("discord_chat_mod.command.send_screenshot.screenshot")).withStyle(style -> style.withColor(ColorUtils.Color.CHAT_LINK_COLOR).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, uniqueFilename)));
                MinecraftUtils.sendMessageToAllPlayersFromPlayer(Map.of("{player}", fromPlayer.getDisplayName(), "{message}", screenshotComponent));
            }
            catch (Exception e) {
                ScreenshotTransceiver.sendErrorMessageToPlayer((Player)fromPlayer, e.getMessage());
            }
        });
    }

    private static void sendScreenshotToDiscord(byte[] rawScreenshotData, ServerPlayer player) {
        DiscordUtils.ImageData screenshotData = (DiscordUtils.ImageData)gson.fromJson(new String(rawScreenshotData), DiscordUtils.ImageData.class);
        Map<String, String> parameters = ChatStyleUtils.mergeMaps(Map.of("{screenshot_url}", String.format("attachment://%s", screenshotData.fileName())), DiscordChatStyleProvider.buildPlayerParameters((Entity)player));
        Optional<DiscordChatStyleProvider.DiscordMessageComponents> chatComponentsOpt = DiscordChatStyleProvider.getDiscordMessageComponents(MessageType.SCREENSHOT, parameters);
        Optional<DiscordChatStyleProvider.DiscordMessageComponents> webhookComponentsOpt = DiscordChatStyleProvider.getDiscordMessageComponents(MessageType.SCREENSHOT_WEBHOOK, parameters);
        if (chatComponentsOpt.isPresent() && webhookComponentsOpt.isPresent()) {
            DiscordUtils.sendMessageFromPlayer(ChannelCategory.SCREENSHOTS, DiscordChannelRegistry.getAllContexts(), (Player)player, webhookComponentsOpt.get(), chatComponentsOpt.get(), screenshotData).ifPresentOrElse(screenshotUrl -> ScreenshotTransceiver.handleSuccessfulDiscordSend(screenshotUrl, (Player)player), () -> ScreenshotTransceiver.sendScreenshotToPlayers(rawScreenshotData, player));
        }
    }

    private static void handleSuccessfulDiscordSend(String screenshotUrl, Player player) {
        MutableComponent screenshotComponent = Component.literal((String)LocaleProvider.getTranslate("discord_chat_mod.command.send_screenshot.screenshot")).withStyle(style -> style.withColor(ColorUtils.Color.CHAT_LINK_COLOR).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, screenshotUrl)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)screenshotUrl))));
        MinecraftUtils.sendMessageToAllPlayersFromPlayer(Map.of("{player}", player.getDisplayName(), "{message}", screenshotComponent));
    }

    private static void sendErrorMessageToPlayer(Player player, String errorMessage) {
        String message = String.format(LocaleProvider.getTranslate("discord_chat_mod.command.send_screenshot.error.with_reason"), errorMessage);
        player.sendSystemMessage((Component)Component.literal((String)message).withStyle(ChatFormatting.RED));
    }
}

