/*
 * Decompiled with CFR 0.152.
 */
package com.shadow.com.electronwill.nightconfig.toml;

import com.shadow.com.electronwill.nightconfig.core.io.CharacterOutput;
import com.shadow.com.electronwill.nightconfig.toml.TomlWriter;
import com.shadow.com.electronwill.nightconfig.toml.ValueWriter;
import java.util.Iterator;
import java.util.List;

final class ArrayWriter {
    private static final char[] EMPTY_ARRAY = new char[]{'[', ']'};
    static final char[] ELEMENT_SEPARATOR = new char[]{',', ' '};

    static void write(List<?> values2, CharacterOutput output, TomlWriter writer) {
        if (values2.isEmpty()) {
            output.write(EMPTY_ARRAY);
            return;
        }
        output.write('[');
        boolean indent = writer.writesIndented(values2);
        if (indent) {
            writer.increaseIndentLevel();
        }
        Iterator<?> iterator2 = values2.iterator();
        boolean hasNext = iterator2.hasNext();
        while (hasNext) {
            if (indent) {
                writer.writeNewline(output);
                writer.writeIndent(output);
            }
            Object value = iterator2.next();
            ValueWriter.write(value, output, writer);
            hasNext = iterator2.hasNext();
            if (!hasNext) continue;
            if (indent) {
                output.write(',');
                continue;
            }
            output.write(ELEMENT_SEPARATOR);
        }
        if (indent) {
            writer.decreaseIndentLevel();
            writer.writeNewline(output);
            writer.writeIndent(output);
        }
        output.write(']');
    }

    private ArrayWriter() {
    }
}

