/*
 * Decompiled with CFR 0.152.
 */
package com.shadow.com.twelvemonkeys.imageio.plugins.webp.lossless;

import com.shadow.com.twelvemonkeys.imageio.plugins.webp.lossless.Transform;
import java.awt.image.WritableRaster;

final class ColorIndexingTransform
implements Transform {
    private final byte[] colorTable;
    private final byte bits;

    public ColorIndexingTransform(byte[] byArray, byte by) {
        this.colorTable = byArray;
        this.bits = by;
    }

    @Override
    public void applyInverse(WritableRaster writableRaster) {
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        byte[] byArray = new byte[4];
        for (int i = 0; i < n2; ++i) {
            for (int j = n - 1; j >= 0; --j) {
                int n3 = 8 >> this.bits;
                int n4 = 1 << this.bits;
                int n5 = j / n4;
                int n6 = n3 * (j % n4);
                int n7 = writableRaster.getSample(n5, i, 1);
                int n8 = n7 >> n6 & (1 << n3) - 1;
                System.arraycopy(this.colorTable, n8 * 4, byArray, 0, 4);
                writableRaster.setDataElements(j, i, byArray);
            }
        }
    }
}

