/*
 * Decompiled with CFR 0.152.
 */
package com.shadow.com.twelvemonkeys.imageio.stream;

import com.shadow.com.twelvemonkeys.imageio.stream.Cache;
import com.shadow.com.twelvemonkeys.lang.Validate;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import javax.imageio.stream.ImageInputStreamImpl;

final class BufferedChannelImageInputStream
extends ImageInputStreamImpl {
    private static final Closeable CLOSEABLE_STUB = new Closeable(){

        @Override
        public void close() {
        }
    };
    static final int DEFAULT_BUFFER_SIZE = 8192;
    private ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
    private byte[] buffer = this.byteBuffer.array();
    private int bufferPos;
    private int bufferLimit;
    private final ByteBuffer integralCache = ByteBuffer.allocate(8);
    private final byte[] integralCacheArray = this.integralCache.array();
    private SeekableByteChannel channel;
    private Closeable closeable;

    public BufferedChannelImageInputStream(File file) throws IOException {
        this(Validate.notNull(file, "file").toPath());
    }

    public BufferedChannelImageInputStream(Path path) throws IOException {
        this(FileChannel.open(Validate.notNull(path, "file"), StandardOpenOption.READ), true);
    }

    public BufferedChannelImageInputStream(RandomAccessFile randomAccessFile) {
        this(Validate.notNull(randomAccessFile, "file").getChannel(), true);
    }

    public BufferedChannelImageInputStream(FileInputStream fileInputStream) {
        this(Validate.notNull(fileInputStream, "inputStream").getChannel(), false);
    }

    public BufferedChannelImageInputStream(SeekableByteChannel seekableByteChannel) {
        this(Validate.notNull(seekableByteChannel, "channel"), false);
    }

    BufferedChannelImageInputStream(Cache cache) {
        this(Validate.notNull(cache, "cache"), true);
    }

    private BufferedChannelImageInputStream(SeekableByteChannel seekableByteChannel, boolean bl) {
        this.channel = Validate.notNull(seekableByteChannel, "channel");
        this.closeable = bl ? this.channel : CLOSEABLE_STUB;
    }

    private boolean fillBuffer() throws IOException {
        this.byteBuffer.rewind();
        int n = this.channel.read(this.byteBuffer);
        this.bufferPos = 0;
        this.bufferLimit = Math.max(n, 0);
        return this.bufferLimit > 0;
    }

    private boolean bufferEmpty() {
        return this.bufferPos >= this.bufferLimit;
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        super.setByteOrder(byteOrder);
        this.integralCache.order(byteOrder);
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (this.bufferEmpty() && !this.fillBuffer()) {
            return -1;
        }
        this.bitOffset = 0;
        ++this.streamPos;
        return this.buffer[this.bufferPos++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        this.checkClosed();
        this.bitOffset = 0;
        if (this.bufferEmpty()) {
            if (n2 >= this.buffer.length) {
                return this.readDirect(byArray, n, n2);
            }
            if (!this.fillBuffer()) {
                return -1;
            }
        }
        if (n2 > (n3 = this.readBuffered(byArray, n, n2))) {
            return n3 + Math.max(0, this.readDirect(byArray, n + n3, n2 - n3));
        }
        return n3;
    }

    private int readDirect(byte[] byArray, int n, int n2) throws IOException {
        this.bufferLimit = 0;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        int n3 = 0;
        while (byteBuffer.hasRemaining()) {
            int n4 = this.channel.read(byteBuffer);
            if (n4 == -1) {
                if (n3 != 0) break;
                return -1;
            }
            n3 += n4;
        }
        this.streamPos += (long)n3;
        return n3;
    }

    private int readBuffered(byte[] byArray, int n, int n2) {
        int n3 = Math.min(this.bufferLimit - this.bufferPos, n2);
        if (n3 > 0) {
            System.arraycopy(this.buffer, this.bufferPos, byArray, n, n3);
            this.bufferPos += n3;
            this.streamPos += (long)n3;
        }
        return n3;
    }

    @Override
    public long length() {
        try {
            this.checkClosed();
            return this.channel.size();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.buffer = null;
        this.byteBuffer = null;
        this.channel = null;
        try {
            this.closeable.close();
        }
        finally {
            this.closeable = null;
        }
    }

    @Override
    public short readShort() throws IOException {
        this.readFully(this.integralCacheArray, 0, 2);
        return this.integralCache.getShort(0);
    }

    @Override
    public int readInt() throws IOException {
        this.readFully(this.integralCacheArray, 0, 4);
        return this.integralCache.getInt(0);
    }

    @Override
    public long readLong() throws IOException {
        this.readFully(this.integralCacheArray, 0, 8);
        return this.integralCache.getLong(0);
    }

    @Override
    public void seek(long l) throws IOException {
        this.checkClosed();
        if (l < this.flushedPos) {
            throw new IndexOutOfBoundsException("position < flushedPos!");
        }
        this.bitOffset = 0;
        if (this.streamPos == l) {
            return;
        }
        long l2 = (long)this.bufferPos + l - this.streamPos;
        if (l2 >= 0L && l2 < (long)this.bufferLimit) {
            this.bufferPos = (int)l2;
        } else {
            this.bufferLimit = 0;
            this.channel.position(l);
        }
        this.streamPos = l;
    }

    @Override
    public void flushBefore(long l) throws IOException {
        super.flushBefore(l);
        if (this.channel instanceof Cache) {
            ((Cache)this.channel).flushBefore(l);
        }
    }
}

