/*
 * Decompiled with CFR 0.152.
 */
package com.shadow.net.dv8tion.jda.api.components.mediagallery;

import com.shadow.net.dv8tion.jda.api.components.Component;
import com.shadow.net.dv8tion.jda.api.components.MessageTopLevelComponent;
import com.shadow.net.dv8tion.jda.api.components.container.ContainerChildComponent;
import com.shadow.net.dv8tion.jda.api.components.mediagallery.MediaGalleryItem;
import com.shadow.net.dv8tion.jda.internal.components.mediagallery.MediaGalleryImpl;
import com.shadow.net.dv8tion.jda.internal.utils.Checks;
import com.shadow.net.dv8tion.jda.internal.utils.Helpers;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.Unmodifiable;

public interface MediaGallery
extends Component,
MessageTopLevelComponent,
ContainerChildComponent {
    public static final int MAX_ITEMS = 10;

    @Nonnull
    public static MediaGallery of(@Nonnull Collection<? extends MediaGalleryItem> items) {
        return MediaGalleryImpl.validated(items);
    }

    @Nonnull
    public static MediaGallery of(@Nonnull MediaGalleryItem item, MediaGalleryItem ... items) {
        Checks.notNull(item, "Item");
        Checks.noneNull(items, "Items");
        return MediaGallery.of(Helpers.mergeVararg(item, items));
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MediaGallery withUniqueId(int var1);

    @Nonnull
    @CheckReturnValue
    public MediaGallery withItems(@Nonnull Collection<? extends MediaGalleryItem> var1);

    @Nonnull
    @CheckReturnValue
    default public MediaGallery withItems(@Nonnull MediaGalleryItem item, MediaGalleryItem ... items) {
        Checks.notNull(item, "Item");
        Checks.notNull(items, "Items");
        return this.withItems(Helpers.mergeVararg(item, items));
    }

    @Nonnull
    public @Unmodifiable List<MediaGalleryItem> getItems();
}

