/*
 * Decompiled with CFR 0.152.
 */
package com.shadow.net.dv8tion.jda.api.utils.messages;

import com.shadow.net.dv8tion.jda.api.components.Component;
import com.shadow.net.dv8tion.jda.api.components.MessageTopLevelComponent;
import com.shadow.net.dv8tion.jda.api.components.MessageTopLevelComponentUnion;
import com.shadow.net.dv8tion.jda.api.entities.IMentionable;
import com.shadow.net.dv8tion.jda.api.entities.Message;
import com.shadow.net.dv8tion.jda.api.entities.MessageEmbed;
import com.shadow.net.dv8tion.jda.api.utils.messages.AllowedMentionsData;
import com.shadow.net.dv8tion.jda.api.utils.messages.MessageRequest;
import com.shadow.net.dv8tion.jda.internal.components.utils.ComponentsUtil;
import com.shadow.net.dv8tion.jda.internal.utils.Checks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractMessageBuilder<T, R extends AbstractMessageBuilder<T, R>>
implements MessageRequest<R> {
    protected static boolean isDefaultUseComponentsV2 = false;
    protected final List<MessageEmbed> embeds = new ArrayList<MessageEmbed>(10);
    protected final List<MessageTopLevelComponentUnion> components = new ArrayList<MessageTopLevelComponentUnion>(5);
    protected final StringBuilder content = new StringBuilder(2000);
    protected AllowedMentionsData mentions = new AllowedMentionsData();
    protected int messageFlags;

    protected AbstractMessageBuilder() {
        this.useComponentsV2(isDefaultUseComponentsV2);
    }

    @Override
    @Nonnull
    public R setContent(@Nullable String content) {
        if (content != null) {
            content = content.trim();
            Checks.notLonger(content, 2000, "Content");
            this.content.setLength(0);
            this.content.append(content);
        } else {
            this.content.setLength(0);
        }
        return (R)this;
    }

    @Override
    @Nonnull
    public String getContent() {
        return this.content.toString();
    }

    @Override
    @Nonnull
    public R mentionRepliedUser(boolean mention) {
        this.mentions.mentionRepliedUser(mention);
        return (R)this;
    }

    @Override
    @Nonnull
    public R setAllowedMentions(@Nullable Collection<Message.MentionType> allowedMentions) {
        this.mentions.setAllowedMentions(allowedMentions);
        return (R)this;
    }

    @Override
    @Nonnull
    public R mention(@Nonnull Collection<? extends IMentionable> mentions) {
        this.mentions.mention(mentions);
        return (R)this;
    }

    @Override
    @Nonnull
    public R mentionUsers(@Nonnull Collection<String> userIds) {
        this.mentions.mentionUsers(userIds);
        return (R)this;
    }

    @Override
    @Nonnull
    public R mentionRoles(@Nonnull Collection<String> roleIds) {
        this.mentions.mentionRoles(roleIds);
        return (R)this;
    }

    @Override
    @Nonnull
    public Set<String> getMentionedUsers() {
        return this.mentions.getMentionedUsers();
    }

    @Override
    @Nonnull
    public Set<String> getMentionedRoles() {
        return this.mentions.getMentionedRoles();
    }

    @Override
    @Nonnull
    public EnumSet<Message.MentionType> getAllowedMentions() {
        return this.mentions.getAllowedMentions();
    }

    @Override
    public boolean isMentionRepliedUser() {
        return this.mentions.isMentionRepliedUser();
    }

    @Override
    @Nonnull
    public R setEmbeds(@Nonnull Collection<? extends MessageEmbed> embeds) {
        Checks.noneNull(embeds, "Embeds");
        Checks.check(embeds.size() <= 10, "Cannot send more than %d embeds in a message!", (Object)10);
        this.embeds.clear();
        this.embeds.addAll(embeds);
        return (R)this;
    }

    @Override
    @Nonnull
    public List<MessageEmbed> getEmbeds() {
        return Collections.unmodifiableList(this.embeds);
    }

    @Override
    @Nonnull
    public R setComponents(@Nonnull Collection<? extends MessageTopLevelComponent> components) {
        Checks.noneNull(components, "MessageTopLevelComponents");
        Checks.checkComponents("Provided component is invalid for messages!", components, Component::isMessageCompatible);
        List<MessageTopLevelComponentUnion> componentsAsUnions = ComponentsUtil.membersToUnion(components, MessageTopLevelComponentUnion.class);
        this.components.clear();
        this.components.addAll(componentsAsUnions);
        return (R)this;
    }

    @Override
    @Nonnull
    public R useComponentsV2(boolean use) {
        int flag = Message.MessageFlag.IS_COMPONENTS_V2.getValue();
        this.messageFlags = use ? (this.messageFlags |= flag) : (this.messageFlags &= ~flag);
        return (R)this;
    }

    @Override
    @Nonnull
    public List<MessageTopLevelComponentUnion> getComponents() {
        return Collections.unmodifiableList(this.components);
    }

    @Override
    public boolean isUsingComponentsV2() {
        return (this.messageFlags & Message.MessageFlag.IS_COMPONENTS_V2.getValue()) != 0;
    }

    @Override
    @Nonnull
    public R setSuppressEmbeds(boolean suppress) {
        int flag = Message.MessageFlag.EMBEDS_SUPPRESSED.getValue();
        this.messageFlags = suppress ? (this.messageFlags |= flag) : (this.messageFlags &= ~flag);
        return (R)this;
    }

    @Override
    public boolean isSuppressEmbeds() {
        return (this.messageFlags & Message.MessageFlag.EMBEDS_SUPPRESSED.getValue()) != 0;
    }

    public long getMessageFlagsRaw() {
        return this.messageFlags;
    }

    public abstract boolean isEmpty();

    public abstract boolean isValid();

    @Nonnull
    public abstract T build();

    @Nonnull
    public R clear() {
        this.embeds.clear();
        this.components.clear();
        this.content.setLength(0);
        this.mentions.clear();
        this.messageFlags = 0;
        return (R)this;
    }

    @Nonnull
    public abstract R closeFiles();
}

