/*
 * Decompiled with CFR 0.152.
 */
package com.shadow.net.dv8tion.jda.internal.components;

import com.shadow.net.dv8tion.jda.api.components.ResolvedMedia;
import com.shadow.net.dv8tion.jda.api.utils.AttachmentProxy;
import com.shadow.net.dv8tion.jda.api.utils.data.DataObject;
import com.shadow.net.dv8tion.jda.internal.utils.EntityString;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ResolvedMediaImpl
implements ResolvedMedia {
    private final String attachmentId;
    private final String url;
    private final String proxyUrl;
    private final int width;
    private final int height;
    private final String contentType;

    public ResolvedMediaImpl(DataObject data) {
        this(data.getString("attachment_id", null), data.getString("url"), data.getString("proxy_url"), data.getInt("width", 0), data.getInt("height", 0), data.getString("content_type", null));
    }

    public ResolvedMediaImpl(String attachmentId, String url, String proxyUrl, int width, int height, String contentType) {
        this.attachmentId = attachmentId;
        this.url = url;
        this.proxyUrl = proxyUrl;
        this.width = width;
        this.height = height;
        this.contentType = contentType;
    }

    @Override
    @Nullable
    public String getAttachmentId() {
        return this.attachmentId;
    }

    @Override
    @Nonnull
    public String getUrl() {
        return this.url;
    }

    @Override
    @Nonnull
    public String getProxyUrl() {
        return this.proxyUrl;
    }

    @Override
    @Nonnull
    public AttachmentProxy getProxy() {
        return new AttachmentProxy(this.width > 0 && this.height > 0 ? this.proxyUrl : this.url);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ResolvedMediaImpl)) {
            return false;
        }
        ResolvedMediaImpl that = (ResolvedMediaImpl)o;
        return Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.url);
    }

    public String toString() {
        return new EntityString(this).addMetadata("proxy_url", this.url).toString();
    }
}

