/*
 * Decompiled with CFR 0.152.
 */
package com.shadow.net.dv8tion.jda.internal.interactions.modal;

import com.shadow.net.dv8tion.jda.api.components.Component;
import com.shadow.net.dv8tion.jda.api.entities.Message;
import com.shadow.net.dv8tion.jda.api.entities.channel.unions.MessageChannelUnion;
import com.shadow.net.dv8tion.jda.api.interactions.modals.ModalInteraction;
import com.shadow.net.dv8tion.jda.api.interactions.modals.ModalMapping;
import com.shadow.net.dv8tion.jda.api.requests.restaction.interactions.MessageEditCallbackAction;
import com.shadow.net.dv8tion.jda.api.requests.restaction.interactions.ReplyCallbackAction;
import com.shadow.net.dv8tion.jda.api.utils.data.DataArray;
import com.shadow.net.dv8tion.jda.api.utils.data.DataObject;
import com.shadow.net.dv8tion.jda.internal.JDAImpl;
import com.shadow.net.dv8tion.jda.internal.interactions.DeferrableInteractionImpl;
import com.shadow.net.dv8tion.jda.internal.requests.restaction.interactions.MessageEditCallbackActionImpl;
import com.shadow.net.dv8tion.jda.internal.requests.restaction.interactions.ReplyCallbackActionImpl;
import com.shadow.net.dv8tion.jda.internal.utils.Helpers;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ModalInteractionImpl
extends DeferrableInteractionImpl
implements ModalInteraction {
    private final String modalId;
    private final List<ModalMapping> mappings;
    private final Message message;

    public ModalInteractionImpl(JDAImpl api, DataObject object) {
        super(api, object);
        DataObject data = object.getObject("data");
        this.modalId = data.getString("custom_id");
        DataObject resolved = data.optObject("resolved").orElseGet(DataObject::empty);
        this.mappings = data.optArray("components").orElseGet(DataArray::empty).stream(DataArray::getObject).map(component -> this.getMapping((DataObject)component, resolved)).filter(Objects::nonNull).collect(Helpers.toUnmodifiableList());
        this.message = object.optObject("message").map(o -> api.getEntityBuilder().createMessageWithChannel((DataObject)o, this.getMessageChannel(), false)).orElse(null);
    }

    private ModalMapping getMapping(DataObject component, DataObject resolved) {
        Component.Type type = Component.Type.fromKey(component.getInt("type"));
        if (type == Component.Type.LABEL) {
            return new ModalMapping(this, resolved, component.getObject("component"));
        }
        return null;
    }

    @Override
    @Nonnull
    public String getModalId() {
        return this.modalId;
    }

    @Override
    @Nonnull
    public List<ModalMapping> getValues() {
        return this.mappings;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    @Nonnull
    public ReplyCallbackAction deferReply() {
        return new ReplyCallbackActionImpl(this.hook);
    }

    @Override
    @Nonnull
    public MessageEditCallbackAction deferEdit() {
        return new MessageEditCallbackActionImpl(this.hook);
    }

    @Override
    @Nonnull
    public MessageChannelUnion getChannel() {
        return (MessageChannelUnion)super.getChannel();
    }
}

