/*
 * Decompiled with CFR 0.152.
 */
package com.shadow.net.dv8tion.jda.internal.managers;

import com.shadow.net.dv8tion.jda.api.entities.StageInstance;
import com.shadow.net.dv8tion.jda.api.managers.StageInstanceManager;
import com.shadow.net.dv8tion.jda.api.requests.Route;
import com.shadow.net.dv8tion.jda.api.utils.data.DataObject;
import com.shadow.net.dv8tion.jda.internal.managers.ManagerBase;
import com.shadow.net.dv8tion.jda.internal.utils.Checks;
import com.shadow.okhttp3.RequestBody;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StageInstanceManagerImpl
extends ManagerBase<StageInstanceManager>
implements StageInstanceManager {
    private final StageInstance instance;
    private String topic;

    public StageInstanceManagerImpl(StageInstance instance) {
        super(instance.getChannel().getJDA(), Route.StageInstances.UPDATE_INSTANCE.compile(instance.getChannel().getId()));
        this.instance = instance;
    }

    @Override
    @Nonnull
    public StageInstance getStageInstance() {
        return this.instance;
    }

    @Override
    @Nonnull
    public StageInstanceManager setTopic(@Nullable String topic) {
        if (topic != null) {
            topic = topic.trim();
            Checks.notLonger(topic, 120, "Topic");
            if (topic.isEmpty()) {
                topic = null;
            }
        }
        this.topic = topic;
        this.set |= 1L;
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        DataObject body = DataObject.empty();
        if (this.shouldUpdate(1L) && this.topic != null) {
            body.put("topic", this.topic);
        }
        return this.getRequestBody(body);
    }
}

