/*
 * Decompiled with CFR 0.152.
 */
package com.shadow.net.dv8tion.jda.internal.utils;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneOffset;
import javax.annotation.Nonnull;

public class ClockProvider {
    private static Clock fixedTime = null;

    @Nonnull
    public static Clock getClock() {
        if (fixedTime != null) {
            return fixedTime;
        }
        return Clock.systemUTC();
    }

    public static void withFixedTime(@Nonnull Instant instant, @Nonnull Runnable runnable2) {
        fixedTime = Clock.fixed(instant, ZoneOffset.UTC);
        try {
            runnable2.run();
        }
        finally {
            fixedTime = null;
        }
    }
}

