/*
 * Decompiled with CFR 0.152.
 */
package xyz.quazaros.compacttools.item.CustomItems;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import xyz.quazaros.compacttools.util.ModTags;

public class ToolItem
extends Item {
    private final ToolMaterial material;
    private final Set<Block> mineableBlocks;
    private final float speed;
    private final float attackSpeed;

    public ToolItem(ToolMaterial material, Item.Properties properties) {
        super(properties.durability(material.durability()));
        this.material = material;
        this.mineableBlocks = Set.of(Blocks.COBWEB, Blocks.BAMBOO);
        this.speed = 1.0f;
        this.attackSpeed = -2.8f;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (state.is(Blocks.COBWEB)) {
            return 50.0f;
        }
        if (state.is(Blocks.BAMBOO)) {
            return 1000.0f;
        }
        if (state.is(ModTags.Blocks.ALL_MINEABLE)) {
            return this.material.speed();
        }
        return 1.0f;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state.is(ModTags.Blocks.ALL_MINEABLE);
    }

    public void hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miner) {
        if (!level.isClientSide && state.getDestroySpeed((BlockGetter)level, pos) != 0.0f) {
            stack.hurtAndBreak(1, miner, EquipmentSlot.MAINHAND);
        }
        return true;
    }
}

