/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.tinytasks.data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class LeaderboardData
extends SavedData {
    private static final String DATA_NAME = "tinytasks_scoreboard";
    private final Map<UUID, Integer> scoreMap = new HashMap<UUID, Integer>();

    public static LeaderboardData load(CompoundTag tag, HolderLookup.Provider provider) {
        LeaderboardData data = new LeaderboardData();
        if (tag.contains("scores")) {
            CompoundTag scoresTag = tag.getCompound("scores");
            for (String key : scoresTag.getAllKeys()) {
                UUID uuid = UUID.fromString(key);
                int score = scoresTag.getInt(key);
                data.scoreMap.put(uuid, score);
            }
        }
        return data;
    }

    public void incrementScore(UUID uuid, int amount) {
        this.scoreMap.merge(uuid, amount, Integer::sum);
    }

    public static void incrementScore(Level level, UUID uuid) {
        LeaderboardData.incrementScore(level, uuid, 1);
    }

    public static void incrementScore(Level level, UUID uuid, int amount) {
        LeaderboardData data = LeaderboardData.get(level);
        data.incrementScore(uuid, amount);
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        CompoundTag scoresTag = new CompoundTag();
        for (Map.Entry<UUID, Integer> entry : this.scoreMap.entrySet()) {
            scoresTag.putInt(entry.getKey().toString(), entry.getValue().intValue());
        }
        tag.put("scores", (Tag)scoresTag);
        return tag;
    }

    public static LeaderboardData get(Level level) {
        if (!(level instanceof ServerLevel)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        ServerLevel overworld = level.getServer().getLevel(Level.OVERWORLD);
        DimensionDataStorage storage = overworld.getDataStorage();
        return (LeaderboardData)storage.computeIfAbsent(new SavedData.Factory(LeaderboardData::new, LeaderboardData::load, null), DATA_NAME);
    }
}

