/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.tinytasks.datagen;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mrbysco.tinytasks.tasks.CraftTask;
import com.mrbysco.tinytasks.tasks.EatTask;
import com.mrbysco.tinytasks.tasks.EquipTask;
import com.mrbysco.tinytasks.tasks.MineTask;
import com.mrbysco.tinytasks.tasks.PickUpTask;
import com.mrbysco.tinytasks.tasks.UseTask;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.WithConditions;

public abstract class TaskProvider
implements DataProvider {
    private final PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> registries;
    private final String modid;
    private final Map<String, WithConditions<CraftTask>> toSerializeCraft = new HashMap<String, WithConditions<CraftTask>>();
    private final Map<String, WithConditions<EatTask>> toSerializeEat = new HashMap<String, WithConditions<EatTask>>();
    private final Map<String, WithConditions<EquipTask>> toSerializeEquip = new HashMap<String, WithConditions<EquipTask>>();
    private final Map<String, WithConditions<MineTask>> toSerializeMine = new HashMap<String, WithConditions<MineTask>>();
    private final Map<String, WithConditions<PickUpTask>> toSerializePickUp = new HashMap<String, WithConditions<PickUpTask>>();
    private final Map<String, WithConditions<UseTask>> toSerializeUse = new HashMap<String, WithConditions<UseTask>>();

    public TaskProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries, String modid) {
        this.output = packOutput;
        this.registries = registries;
        this.modid = modid;
    }

    public final CompletableFuture<?> run(CachedOutput cache) {
        return this.registries.thenCompose(registries -> this.run(cache, (HolderLookup.Provider)registries));
    }

    public CompletableFuture<?> run(CachedOutput cache, HolderLookup.Provider registries) {
        this.start();
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        Path craftPath = this.output.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(this.modid).resolve("tinytasks").resolve("craft_task");
        for (Map.Entry<String, WithConditions<CraftTask>> entry : this.toSerializeCraft.entrySet()) {
            String string = entry.getKey();
            WithConditions<CraftTask> withConditions = entry.getValue();
            Codec<Optional<WithConditions<CraftTask>>> codec = ((CraftTask)withConditions.carrier()).conditionalCodec();
            Path path = craftPath.resolve(string + ".json");
            futuresBuilder.add((Object)DataProvider.saveStable((CachedOutput)cache, (HolderLookup.Provider)registries, codec, Optional.of(withConditions), (Path)path));
        }
        Path eatPath = this.output.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(this.modid).resolve("tinytasks").resolve("eat_task");
        for (Map.Entry<String, WithConditions<EatTask>> entry : this.toSerializeEat.entrySet()) {
            String string = entry.getKey();
            WithConditions<EatTask> withConditions = entry.getValue();
            Codec<Optional<WithConditions<EatTask>>> codec = ((EatTask)withConditions.carrier()).conditionalCodec();
            Path modifierPath = eatPath.resolve(string + ".json");
            futuresBuilder.add((Object)DataProvider.saveStable((CachedOutput)cache, (HolderLookup.Provider)registries, codec, Optional.of(withConditions), (Path)modifierPath));
        }
        Path path = this.output.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(this.modid).resolve("tinytasks").resolve("equip_task");
        for (Map.Entry<String, WithConditions<EquipTask>> entry : this.toSerializeEquip.entrySet()) {
            String string = entry.getKey();
            WithConditions<EquipTask> withConditions = entry.getValue();
            Codec<Optional<WithConditions<EquipTask>>> conditionalCodec = ((EquipTask)withConditions.carrier()).conditionalCodec();
            Path modifierPath = path.resolve(string + ".json");
            futuresBuilder.add((Object)DataProvider.saveStable((CachedOutput)cache, (HolderLookup.Provider)registries, conditionalCodec, Optional.of(withConditions), (Path)modifierPath));
        }
        Path path2 = this.output.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(this.modid).resolve("tinytasks").resolve("mine_task");
        for (Map.Entry<String, WithConditions<MineTask>> entry : this.toSerializeMine.entrySet()) {
            String string = entry.getKey();
            WithConditions<MineTask> modifier = entry.getValue();
            Codec<Optional<WithConditions<MineTask>>> conditionalCodec = ((MineTask)modifier.carrier()).conditionalCodec();
            Path modifierPath = path2.resolve(string + ".json");
            futuresBuilder.add((Object)DataProvider.saveStable((CachedOutput)cache, (HolderLookup.Provider)registries, conditionalCodec, Optional.of(modifier), (Path)modifierPath));
        }
        Path path3 = this.output.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(this.modid).resolve("tinytasks").resolve("pick_up_task");
        for (Map.Entry<String, WithConditions<PickUpTask>> entry : this.toSerializePickUp.entrySet()) {
            String name = entry.getKey();
            WithConditions<PickUpTask> modifier = entry.getValue();
            Codec<Optional<WithConditions<PickUpTask>>> conditionalCodec = ((PickUpTask)modifier.carrier()).conditionalCodec();
            Path modifierPath = path3.resolve(name + ".json");
            futuresBuilder.add((Object)DataProvider.saveStable((CachedOutput)cache, (HolderLookup.Provider)registries, conditionalCodec, Optional.of(modifier), (Path)modifierPath));
        }
        Path path4 = this.output.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(this.modid).resolve("tinytasks").resolve("use_task");
        for (Map.Entry<String, WithConditions<UseTask>> entry : this.toSerializeUse.entrySet()) {
            String name = entry.getKey();
            WithConditions<UseTask> modifier = entry.getValue();
            Codec<Optional<WithConditions<UseTask>>> conditionalCodec = ((UseTask)modifier.carrier()).conditionalCodec();
            Path modifierPath = path4.resolve(name + ".json");
            futuresBuilder.add((Object)DataProvider.saveStable((CachedOutput)cache, (HolderLookup.Provider)registries, conditionalCodec, Optional.of(modifier), (Path)modifierPath));
        }
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }

    protected abstract void start();

    public void addCraftTask(String taskID, CraftTask instance, List<ICondition> conditions) {
        this.toSerializeCraft.put(taskID, (WithConditions<CraftTask>)new WithConditions(conditions, (Object)instance));
    }

    public void addCraftTask(String taskID, CraftTask instance, ICondition ... conditions) {
        this.addCraftTask(taskID, instance, Arrays.asList(conditions));
    }

    public void addEatTask(String taskID, EatTask instance, List<ICondition> conditions) {
        this.toSerializeEat.put(taskID, (WithConditions<EatTask>)new WithConditions(conditions, (Object)instance));
    }

    public void addEatTask(String taskID, EatTask instance, ICondition ... conditions) {
        this.addEatTask(taskID, instance, Arrays.asList(conditions));
    }

    public void addEquipTask(String taskID, EquipTask instance, List<ICondition> conditions) {
        this.toSerializeEquip.put(taskID, (WithConditions<EquipTask>)new WithConditions(conditions, (Object)instance));
    }

    public void addEquipTask(String taskID, EquipTask instance, ICondition ... conditions) {
        this.addEquipTask(taskID, instance, Arrays.asList(conditions));
    }

    public void addMineTask(String taskID, MineTask instance, List<ICondition> conditions) {
        this.toSerializeMine.put(taskID, (WithConditions<MineTask>)new WithConditions(conditions, (Object)instance));
    }

    public void addMineTask(String taskID, MineTask instance, ICondition ... conditions) {
        this.addMineTask(taskID, instance, Arrays.asList(conditions));
    }

    public void addPickUpTask(String taskID, PickUpTask instance, List<ICondition> conditions) {
        this.toSerializePickUp.put(taskID, (WithConditions<PickUpTask>)new WithConditions(conditions, (Object)instance));
    }

    public void addPickUpTask(String taskID, PickUpTask instance, ICondition ... conditions) {
        this.addPickUpTask(taskID, instance, Arrays.asList(conditions));
    }

    public void addUseTask(String taskID, UseTask instance, List<ICondition> conditions) {
        this.toSerializeUse.put(taskID, (WithConditions<UseTask>)new WithConditions(conditions, (Object)instance));
    }

    public void addUseTask(String taskID, UseTask instance, ICondition ... conditions) {
        this.addUseTask(taskID, instance, Arrays.asList(conditions));
    }

    public String getName() {
        return "Task Provider: " + this.modid;
    }
}

