/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.tinytasks.tasks;

import com.mrbysco.tinytasks.TinyTasksMod;
import com.mrbysco.tinytasks.tasks.Task;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractItemTask
implements Task {
    private final RandomSource randomSource = RandomSource.create();
    private final List<Holder<Item>> items;
    private final int weight;
    private Item chosenItem;

    public AbstractItemTask(List<Holder<Item>> items, int weight) {
        this.items = items;
        this.weight = weight;
    }

    @Nullable
    public Item chosenItem() {
        if (this.chosenItem == null) {
            this.selectItem(this.randomSource);
        }
        return this.chosenItem;
    }

    public void selectItem(@NotNull RandomSource randomSource) {
        if (this.items.isEmpty()) {
            throw new IllegalStateException(String.format("No items available for %s Task", this.getName()));
        }
        this.chosenItem = (Item)this.items.get(randomSource.nextInt(this.items.size())).value();
    }

    public void clearSelectedItem() {
        this.chosenItem = null;
    }

    public boolean matches(@NotNull ItemStack stack) {
        if (this.chosenItem == null) {
            TinyTasksMod.LOGGER.error("No item selected for Pick Up Task, cannot match with stack: {}", (Object)stack);
            return false;
        }
        return stack.is(this.chosenItem);
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    public List<Holder<Item>> items() {
        return this.items;
    }

    public int weight() {
        return this.weight;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractItemTask that = (AbstractItemTask)obj;
        return Objects.equals(this.items, that.items) && this.weight == that.weight;
    }

    public int hashCode() {
        return Objects.hash(this.items, this.weight);
    }
}

