/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.tinytasks;

import com.mrbysco.tinytasks.TinyTasksMod;
import com.mrbysco.tinytasks.tasks.CraftTask;
import com.mrbysco.tinytasks.tasks.EatTask;
import com.mrbysco.tinytasks.tasks.EquipTask;
import com.mrbysco.tinytasks.tasks.MineTask;
import com.mrbysco.tinytasks.tasks.PickUpTask;
import com.mrbysco.tinytasks.tasks.Task;
import com.mrbysco.tinytasks.tasks.UseTask;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import org.jetbrains.annotations.NotNull;

public class TaskRegistry {
    private static final List<Task> tasks = new ArrayList<Task>();

    public static List<Task> getTasks() {
        return List.copyOf(tasks);
    }

    public static void onNewRegistry(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(CraftTask.REGISTRY_KEY, CraftTask.CODEC);
        event.dataPackRegistry(EatTask.REGISTRY_KEY, EatTask.CODEC);
        event.dataPackRegistry(EquipTask.REGISTRY_KEY, EquipTask.CODEC);
        event.dataPackRegistry(MineTask.REGISTRY_KEY, MineTask.CODEC);
        event.dataPackRegistry(PickUpTask.REGISTRY_KEY, PickUpTask.CODEC);
        event.dataPackRegistry(UseTask.REGISTRY_KEY, UseTask.CODEC);
    }

    public static void onServerStarted(ServerStartedEvent event) {
        RegistryAccess.Frozen registryAccess = event.getServer().registryAccess();
        TaskRegistry.reloadTasks((RegistryAccess)registryAccess);
    }

    private static void reloadTasks(RegistryAccess registryAccess) {
        tasks.clear();
        Registry craftTaskRegistry = registryAccess.lookupOrThrow(CraftTask.REGISTRY_KEY);
        ArrayList craftTasks = new ArrayList();
        craftTaskRegistry.entrySet().forEach(key -> craftTasks.add((CraftTask)key.getValue()));
        tasks.addAll(craftTasks);
        TinyTasksMod.LOGGER.info("Loaded {} craft tasks", (Object)craftTasks.size());
        Registry eatTaskRegistry = registryAccess.lookupOrThrow(EatTask.REGISTRY_KEY);
        ArrayList eatTasks = new ArrayList();
        eatTaskRegistry.entrySet().forEach(key -> eatTasks.add((EatTask)key.getValue()));
        tasks.addAll(eatTasks);
        TinyTasksMod.LOGGER.info("Loaded {} eat tasks", (Object)eatTasks.size());
        Registry equipTaskRegistry = registryAccess.lookupOrThrow(EquipTask.REGISTRY_KEY);
        ArrayList equipTasks = new ArrayList();
        equipTaskRegistry.entrySet().forEach(key -> equipTasks.add((EquipTask)key.getValue()));
        tasks.addAll(equipTasks);
        TinyTasksMod.LOGGER.info("Loaded {} equip tasks", (Object)equipTasks.size());
        Registry mineTaskRegistry = registryAccess.lookupOrThrow(MineTask.REGISTRY_KEY);
        ArrayList mineTasks = new ArrayList();
        mineTaskRegistry.entrySet().forEach(key -> mineTasks.add((MineTask)key.getValue()));
        tasks.addAll(mineTasks);
        TinyTasksMod.LOGGER.info("Loaded {} mine tasks", (Object)mineTasks.size());
        Registry pickUpTaskRegistry = registryAccess.lookupOrThrow(PickUpTask.REGISTRY_KEY);
        ArrayList pickUpTasks = new ArrayList();
        pickUpTaskRegistry.entrySet().forEach(key -> pickUpTasks.add((PickUpTask)key.getValue()));
        tasks.addAll(pickUpTasks);
        TinyTasksMod.LOGGER.info("Loaded {} pick up tasks", (Object)pickUpTasks.size());
        Registry useTaskRegistry = registryAccess.lookupOrThrow(UseTask.REGISTRY_KEY);
        ArrayList useTasks = new ArrayList();
        useTaskRegistry.entrySet().forEach(key -> useTasks.add((UseTask)key.getValue()));
        tasks.addAll(useTasks);
        TinyTasksMod.LOGGER.info("Loaded {} use tasks", (Object)useTasks.size());
        TinyTasksMod.LOGGER.info("Loaded {} tasks in total", (Object)tasks.size());
        if (!tasks.isEmpty()) {
            tasks.sort(Comparator.comparingInt(Task::getWeight));
        }
    }

    @NotNull
    public static Task getRandomTask() {
        List<Task> tasks = TaskRegistry.getTasks();
        double totalWeight = 0.0;
        for (Task task : tasks) {
            totalWeight += (double)task.getWeight();
        }
        int randomIndex = -1;
        double random = Math.random() * totalWeight;
        for (int i = 0; i < tasks.size(); ++i) {
            if (!((random -= (double)tasks.get(i).getWeight()) <= 0.0)) continue;
            randomIndex = i;
            break;
        }
        return tasks.get(randomIndex);
    }
}

