/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.tinytasks.data;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class LeaderboardData
extends SavedData {
    private static final String DATA_NAME = "tinytasks_scoreboard";
    public static final Codec<LeaderboardData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, (Codec)Codec.INT).fieldOf("scores").forGetter(data -> data.scoreMap)).apply((Applicative)inst, LeaderboardData::new));
    private final Map<UUID, Integer> scoreMap = new HashMap<UUID, Integer>();

    public LeaderboardData() {
        this(Maps.newHashMap());
    }

    public LeaderboardData(Map<UUID, Integer> scoreMap) {
        this.scoreMap.putAll(scoreMap);
    }

    public void incrementScore(UUID uuid, int amount) {
        this.scoreMap.merge(uuid, amount, Integer::sum);
    }

    public static void incrementScore(Level level, UUID uuid) {
        LeaderboardData.incrementScore(level, uuid, 1);
    }

    public static void incrementScore(Level level, UUID uuid, int amount) {
        LeaderboardData data = LeaderboardData.get(level);
        data.incrementScore(uuid, amount);
    }

    public static SavedDataType<LeaderboardData> type() {
        return new SavedDataType(DATA_NAME, LeaderboardData::new, CODEC, null);
    }

    public static LeaderboardData get(Level level) {
        if (!(level instanceof ServerLevel)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        ServerLevel overworld = level.getServer().getLevel(Level.OVERWORLD);
        assert (overworld != null);
        DimensionDataStorage storage = overworld.getDataStorage();
        return (LeaderboardData)storage.computeIfAbsent(LeaderboardData.type());
    }
}

