/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.tinytasks.handler;

import com.mrbysco.tinytasks.TaskRegistry;
import com.mrbysco.tinytasks.data.LeaderboardData;
import com.mrbysco.tinytasks.tasks.CraftTask;
import com.mrbysco.tinytasks.tasks.EatTask;
import com.mrbysco.tinytasks.tasks.EquipTask;
import com.mrbysco.tinytasks.tasks.MineTask;
import com.mrbysco.tinytasks.tasks.PickUpTask;
import com.mrbysco.tinytasks.tasks.Task;
import com.mrbysco.tinytasks.tasks.UseTask;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber
public class TaskHandler {
    private static final int TASK_DURATION = 600;
    private static Task currentTask = null;
    private static long completeTime = 0L;
    private static final List<UUID> completedPlayers = new ArrayList<UUID>();

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        boolean canHaveTask;
        MinecraftServer server = event.getServer();
        boolean bl = canHaveTask = !server.getPlayerList().getPlayers().isEmpty();
        if (currentTask == null) {
            if (canHaveTask) {
                currentTask = TaskRegistry.getRandomTask();
            }
        } else {
            ServerLevel serverLevel = server.overworld();
            if (serverLevel.getGameTime() % 20L == 0L) {
                MutableComponent component = Component.literal((String)"Tiny Task: ").withStyle(ChatFormatting.YELLOW);
                component = component.append(TaskHandler.getTaskDescription(currentTask));
                for (ServerPlayer serverPlayer : server.getPlayerList().getPlayers()) {
                    if (completedPlayers.contains(serverPlayer.getUUID())) continue;
                    serverPlayer.displayClientMessage((Component)component, true);
                }
                if (!canHaveTask || completeTime != 0L && serverLevel.getGameTime() - completeTime >= 600L) {
                    server.getPlayerList().broadcastSystemMessage((Component)Component.literal((String)"\u00a7cTask ended!"), false);
                    currentTask = null;
                    completeTime = 0L;
                    completedPlayers.clear();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onCrafted(PlayerEvent.ItemCraftedEvent event) {
        Task task;
        Player player = event.getEntity();
        Level level = player.level();
        if (!level.isClientSide() && (task = currentTask) instanceof CraftTask) {
            ItemStack stack;
            CraftTask craftTask = (CraftTask)task;
            if (!completedPlayers.contains(player.getUUID()) && craftTask.matches(stack = event.getCrafting())) {
                TaskHandler.userCompletedTask((ServerLevel)level, player);
            }
        }
    }

    @SubscribeEvent
    public static void onPickup(ItemEntityPickupEvent.Pre event) {
        Task task;
        Player player = event.getPlayer();
        Level level = player.level();
        if (!level.isClientSide() && (task = currentTask) instanceof PickUpTask) {
            ItemStack stack;
            PickUpTask pickUpTask = (PickUpTask)task;
            if (!completedPlayers.contains(player.getUUID()) && pickUpTask.matches(stack = event.getItemEntity().getItem())) {
                TaskHandler.userCompletedTask((ServerLevel)level, player);
            }
        }
    }

    @SubscribeEvent
    public static void onEquip(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        Level level = livingEntity.level();
        if (!level.isClientSide() && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            Task task = currentTask;
            if (task instanceof EquipTask) {
                ItemStack stack;
                EquipTask equipTask = (EquipTask)task;
                if (!completedPlayers.contains(player.getUUID()) && equipTask.matches(stack = event.getTo())) {
                    TaskHandler.userCompletedTask((ServerLevel)level, player);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onUse(LivingEntityUseItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        Level level = livingEntity.level();
        if (!level.isClientSide() && livingEntity instanceof Player) {
            ItemStack stack;
            UseTask useTask;
            Player player = (Player)livingEntity;
            Task task = currentTask;
            if (task instanceof UseTask && (useTask = (UseTask)task).matches(stack = event.getItem())) {
                TaskHandler.userCompletedTask((ServerLevel)level, player);
            }
        }
    }

    @SubscribeEvent
    public static void onUse(BlockEvent.BreakEvent event) {
        Task task;
        Player player = event.getPlayer();
        Level level = player.level();
        if (!level.isClientSide() && (task = currentTask) instanceof MineTask) {
            MineTask mineTask = (MineTask)task;
            if (!completedPlayers.contains(player.getUUID()) && mineTask.matches(event.getState().getBlock().asItem().getDefaultInstance())) {
                TaskHandler.userCompletedTask((ServerLevel)level, player);
            }
        }
    }

    public static void onEat(LivingEntity livingEntity, ItemStack stack) {
        Level level = livingEntity.level();
        if (!level.isClientSide() && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            Task task = currentTask;
            if (task instanceof EatTask) {
                EatTask eatTask = (EatTask)task;
                if (!completedPlayers.contains(player.getUUID()) && eatTask.matches(stack)) {
                    TaskHandler.userCompletedTask((ServerLevel)level, player);
                }
            }
        }
    }

    private static void userCompletedTask(ServerLevel serverLevel, Player player) {
        UUID playerId = player.getGameProfile().id();
        if (completedPlayers.contains(playerId)) {
            return;
        }
        LeaderboardData.incrementScore((Level)serverLevel, player.getGameProfile().id());
        TaskHandler.broadcastTaskCompletion(serverLevel, player, completeTime == -1L);
        if (completeTime == -1L) {
            completeTime = serverLevel.getGameTime();
        }
        completedPlayers.add(player.getGameProfile().id());
    }

    private static void broadcastTaskCompletion(ServerLevel level, Player player, boolean firstTime) {
        String completionMessage = "\u00a76%s\u00a7r has completed the task";
        if (firstTime) {
            completionMessage = "\u00a76%s\u00a7r has completed the task first";
        }
        MutableComponent component = Component.literal((String)String.format(completionMessage, player.getDisplayName().getString())).withStyle(ChatFormatting.YELLOW);
        component.setStyle(component.getStyle().withHoverEvent((HoverEvent)new HoverEvent.ShowText(TaskHandler.getTaskDescription(currentTask))));
        level.getServer().getPlayerList().broadcastSystemMessage((Component)component, false);
    }

    private static Component getTaskDescription(Task task) {
        if (task == null) {
            return Component.literal((String)"No current task");
        }
        return Component.literal((String)task.getDescription()).withStyle(ChatFormatting.WHITE);
    }
}

