/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.tinytasks.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrbysco.tinytasks.TinyTasksMod;
import com.mrbysco.tinytasks.tasks.AbstractItemTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.WithConditions;

public class EquipTask
extends AbstractItemTask {
    public static final ResourceKey<Registry<EquipTask>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)TinyTasksMod.modLoc("equip_task"));
    public static final Codec<EquipTask> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Item.CODEC.listOf().fieldOf("items").forGetter(AbstractItemTask::items), (App)Codec.intRange((int)1, (int)100).fieldOf("weight").forGetter(AbstractItemTask::weight)).apply((Applicative)instance, EquipTask::new));

    public EquipTask(List<Holder<Item>> items, int weight) {
        super(items, weight);
    }

    @Override
    public String getName() {
        return "Equip Task";
    }

    @Override
    public String getDescription() {
        if (this.chosenItem() == null) {
            throw new IllegalStateException("No item selected for Equip Task");
        }
        return String.format("Equip 1 %s", Component.translatable((String)this.chosenItem().getDescriptionId()).getString());
    }

    public Codec<EquipTask> codec() {
        return CODEC;
    }

    public Codec<Optional<WithConditions<EquipTask>>> conditionalCodec() {
        return ConditionalOps.createConditionalCodecWithConditions(CODEC);
    }

    public String toString() {
        return "EquipTask[items=" + String.valueOf(this.items()) + ", weight=" + this.weight() + "]";
    }

    public static class Builder {
        private final List<Holder<Item>> items = new ArrayList<Holder<Item>>();
        private int weight = 10;

        public Builder addItem(ItemLike item) {
            this.addItemInternal(item);
            return this;
        }

        public Builder addItems(ItemLike ... items) {
            for (ItemLike item : items) {
                this.addItemInternal(item);
            }
            return this;
        }

        private void addItemInternal(ItemLike itemLike) {
            Holder.Reference itemHolder = itemLike.asItem().builtInRegistryHolder();
            if (this.items.contains(itemHolder)) {
                throw new IllegalArgumentException("Item " + String.valueOf(itemHolder) + " is already added to the task");
            }
            this.items.add((Holder<Item>)itemHolder);
        }

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public EquipTask build() {
            if (this.items.isEmpty()) {
                throw new IllegalArgumentException("Items list cannot be empty");
            }
            return new EquipTask(this.items, this.weight);
        }
    }
}

