package ing.slonk.somewhatmending.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import ing.slonk.somewhatmending.Config;
import ing.slonk.somewhatmending.Config.Mode;
import ing.slonk.somewhatmending.SomewhatMending;
import net.minecraft.class_1661;
import net.minecraft.class_1706;
import net.minecraft.class_1799;
import net.minecraft.class_3532;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_4861;
import net.minecraft.class_8047;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import net.minecraft.world.inventory.*;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Objects;

@Mixin(class_1706.class)
public abstract class AnvilMenuMixin extends class_4861 {
	@Shadow
	@Final
	private class_3915 cost;

	@Shadow
	private int repairItemCountCost;

	public AnvilMenuMixin(@Nullable class_3917<?> menuType, int i, class_1661 inventory, class_3914 containerLevelAccess, class_8047 itemCombinerMenuSlotDefinition) {
		super(menuType, i, inventory, containerLevelAccess, itemCombinerMenuSlotDefinition);
	}

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/world/inventory/DataSlot;set(I)V", ordinal = 5, shift = At.Shift.AFTER), method = "createResult()V")
	private void calculateCost(CallbackInfo ci, @Local(ordinal = 0) class_1799 firstItem, @Local(ordinal = 2) class_1799 secondItem, @Local(ordinal = 0) int operationCount) {
		if (!Config.doAnvilRepairBuff) return;

		SomewhatMending.LOGGER.debug(" first {}", firstItem);
		SomewhatMending.LOGGER.debug("second {}", secondItem);

		SomewhatMending.LOGGER.debug(" first repair cost {}, base {}", firstItem.method_57825(class_9334.field_49639, 0), firstItem.method_7909().method_7854().method_57825(class_9334.field_49639, 0));
		SomewhatMending.LOGGER.debug("second repair cost {}, base {}", secondItem.method_57825(class_9334.field_49639, 0), secondItem.method_7909().method_7854().method_57825(class_9334.field_49639, 0));

		SomewhatMending.LOGGER.debug("repairItemCountCost {}, operationCount {}", repairItemCountCost, operationCount);

		boolean hasMending = firstItem.method_57826(class_9334.field_49633) && Objects.requireNonNull(firstItem.method_57824(class_9334.field_49633))
			.method_57539().stream()
			.anyMatch((x) ->
				x.getIntValue() > 0 &&
					!x.getKey().comp_349().method_60034(class_9701.field_51652).isEmpty()
			);

		SomewhatMending.LOGGER.debug("hasMending: {}", hasMending);

		if (repairItemCountCost == operationCount && hasMending) {
			SomewhatMending.LOGGER.debug("applying mending buff");

			long newTotal = switch (Config.mode) {
				case Mode.DEFAULT ->
					(long) firstItem.method_7909().method_7854().method_57825(class_9334.field_49639, 0) +
						(long) secondItem.method_57825(class_9334.field_49639, 0) +
						(long) operationCount;
				case Mode.LOG2 -> class_3532.method_15342((int) class_3532.method_53062(
					(long) firstItem.method_57825(class_9334.field_49639, 0) +
						(long) secondItem.method_57825(class_9334.field_49639, 0) +
						(long) operationCount,
					0, Integer.MAX_VALUE
				));
				case Mode.MULTIPLY ->
					Math.round((double) ((long) firstItem.method_57825(class_9334.field_49639, 0) +
						(long) secondItem.method_57825(class_9334.field_49639, 0) +
						(long) operationCount) * Config.mulValue);
				case Mode.SUBTRACT -> (long) firstItem.method_57825(class_9334.field_49639, 0) +
					(long) secondItem.method_57825(class_9334.field_49639, 0) +
					(long) operationCount - Config.subValue;
				case Mode.CONSTANT -> Config.constValue;
			};

			int clamped = (int) class_3532.method_53062(newTotal, Config.mode == Mode.CONSTANT ? 0L : 1L, Integer.MAX_VALUE);
			cost.method_17404(clamped);
		}
	}
}