/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.std;

import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.annotation.JsonFormat;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.core.JsonParser;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.core.JsonToken;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.BeanProperty;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.DeserializationConfig;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.DeserializationContext;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.DeserializationFeature;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.JavaType;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.JsonDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.JsonMappingException;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.NullValueProvider;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.type.LogicalType;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.util.AccessPattern;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.util.ObjectBuffer;
import java.io.IOException;
import java.util.Objects;

@JacksonStdImpl
public final class StringArrayDeserializer
extends StdDeserializer<String[]>
implements ContextualDeserializer {
    private static final long serialVersionUID = 2L;
    private static final String[] NO_STRINGS = new String[0];
    public static final StringArrayDeserializer instance = new StringArrayDeserializer();
    protected JsonDeserializer<String> _elementDeserializer;
    protected final NullValueProvider _nullProvider;
    protected final Boolean _unwrapSingle;
    protected final boolean _skipNullValues;

    public StringArrayDeserializer() {
        this(null, null, null);
    }

    protected StringArrayDeserializer(JsonDeserializer<?> deser, NullValueProvider nuller, Boolean unwrapSingle) {
        super(String[].class);
        this._elementDeserializer = deser;
        this._nullProvider = nuller;
        this._unwrapSingle = unwrapSingle;
        this._skipNullValues = NullsConstantProvider.isSkipper(nuller);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Array;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig config2) {
        return Boolean.TRUE;
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.CONSTANT;
    }

    @Override
    public Object getEmptyValue(DeserializationContext ctxt) throws JsonMappingException {
        return NO_STRINGS;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property2) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._elementDeserializer;
        deser = this.findConvertingContentDeserializer(ctxt, property2, deser);
        JavaType type = ctxt.constructType(String.class);
        deser = deser == null ? ctxt.findContextualValueDeserializer(type, property2) : ctxt.handleSecondaryContextualization(deser, property2, type);
        Boolean unwrapSingle = this.findFormatFeature(ctxt, property2, String[].class, JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        NullValueProvider nuller = this.findContentNullProvider(ctxt, property2, deser);
        if (deser != null && this.isDefaultDeserializer(deser)) {
            deser = null;
        }
        if (this._elementDeserializer == deser && Objects.equals(this._unwrapSingle, unwrapSingle) && this._nullProvider == nuller) {
            return this;
        }
        return new StringArrayDeserializer(deser, nuller, unwrapSingle);
    }

    @Override
    public String[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (!p.isExpectedStartArrayToken()) {
            return this.handleNonArray(p, ctxt);
        }
        if (this._elementDeserializer != null) {
            return this._deserializeCustom(p, ctxt, null);
        }
        ObjectBuffer buffer = ctxt.leaseObjectBuffer();
        Object[] chunk = buffer.resetAndStart();
        int ix = 0;
        try {
            while (true) {
                String value2;
                if ((value2 = p.nextTextValue()) == null) {
                    JsonToken t = p.currentToken();
                    if (t == JsonToken.END_ARRAY) break;
                    if (t == JsonToken.VALUE_NULL) {
                        if (this._skipNullValues) continue;
                        value2 = (String)this._nullProvider.getNullValue(ctxt);
                    } else {
                        value2 = this._parseString(p, ctxt);
                    }
                }
                if (ix >= chunk.length) {
                    chunk = buffer.appendCompletedChunk(chunk);
                    ix = 0;
                }
                chunk[ix++] = value2;
            }
        }
        catch (Exception e) {
            throw JsonMappingException.wrapWithPath((Throwable)e, (Object)chunk, buffer.bufferedSize() + ix);
        }
        String[] result2 = buffer.completeAndClearBuffer(chunk, ix, String.class);
        ctxt.returnObjectBuffer(buffer);
        return result2;
    }

    protected final String[] _deserializeCustom(JsonParser p, DeserializationContext ctxt, String[] old2) throws IOException {
        Object[] chunk;
        int ix;
        ObjectBuffer buffer = ctxt.leaseObjectBuffer();
        if (old2 == null) {
            ix = 0;
            chunk = buffer.resetAndStart();
        } else {
            ix = old2.length;
            chunk = buffer.resetAndStart(old2, ix);
        }
        JsonDeserializer<String> deser = this._elementDeserializer;
        try {
            while (true) {
                String value2;
                if (p.nextTextValue() == null) {
                    JsonToken t = p.currentToken();
                    if (t == JsonToken.END_ARRAY) break;
                    if (t == JsonToken.VALUE_NULL) {
                        if (this._skipNullValues) continue;
                        value2 = (String)this._nullProvider.getNullValue(ctxt);
                    } else {
                        value2 = deser.deserialize(p, ctxt);
                    }
                } else {
                    value2 = deser.deserialize(p, ctxt);
                }
                if (ix >= chunk.length) {
                    chunk = buffer.appendCompletedChunk(chunk);
                    ix = 0;
                }
                chunk[ix++] = value2;
            }
        }
        catch (Exception e) {
            throw JsonMappingException.wrapWithPath((Throwable)e, String.class, ix);
        }
        String[] result2 = buffer.completeAndClearBuffer(chunk, ix, String.class);
        ctxt.returnObjectBuffer(buffer);
        return result2;
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromArray(p, ctxt);
    }

    @Override
    public String[] deserialize(JsonParser p, DeserializationContext ctxt, String[] intoValue) throws IOException {
        if (!p.isExpectedStartArrayToken()) {
            String[] arr = this.handleNonArray(p, ctxt);
            if (arr == null) {
                return intoValue;
            }
            int offset = intoValue.length;
            String[] result2 = new String[offset + arr.length];
            System.arraycopy(intoValue, 0, result2, 0, offset);
            System.arraycopy(arr, 0, result2, offset, arr.length);
            return result2;
        }
        if (this._elementDeserializer != null) {
            return this._deserializeCustom(p, ctxt, intoValue);
        }
        ObjectBuffer buffer = ctxt.leaseObjectBuffer();
        int ix = intoValue.length;
        Object[] chunk = buffer.resetAndStart(intoValue, ix);
        try {
            while (true) {
                String value2;
                if ((value2 = p.nextTextValue()) == null) {
                    JsonToken t = p.currentToken();
                    if (t == JsonToken.END_ARRAY) break;
                    if (t == JsonToken.VALUE_NULL) {
                        if (this._skipNullValues) {
                            return NO_STRINGS;
                        }
                        value2 = (String)this._nullProvider.getNullValue(ctxt);
                    } else {
                        value2 = this._parseString(p, ctxt);
                    }
                }
                if (ix >= chunk.length) {
                    chunk = buffer.appendCompletedChunk(chunk);
                    ix = 0;
                }
                chunk[ix++] = value2;
            }
        }
        catch (Exception e) {
            throw JsonMappingException.wrapWithPath((Throwable)e, (Object)chunk, buffer.bufferedSize() + ix);
        }
        String[] result3 = buffer.completeAndClearBuffer(chunk, ix, String.class);
        ctxt.returnObjectBuffer(buffer);
        return result3;
    }

    private final String[] handleNonArray(JsonParser p, DeserializationContext ctxt) throws IOException {
        boolean canWrap;
        boolean bl = canWrap = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && ctxt.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (canWrap) {
            String value2 = p.hasToken(JsonToken.VALUE_NULL) ? (String)this._nullProvider.getNullValue(ctxt) : this._parseString(p, ctxt);
            return new String[]{value2};
        }
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            return (String[])this._deserializeFromString(p, ctxt);
        }
        return (String[])ctxt.handleUnexpectedToken(this._valueClass, p);
    }
}

