/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.datatype.jsr310.ser;

import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.annotation.JsonFormat;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.core.JsonGenerator;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.core.JsonToken;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.core.type.WritableTypeId;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.JavaType;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.JsonMappingException;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.SerializerProvider;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class LocalDateSerializer
extends JSR310FormattedSerializerBase<LocalDate> {
    private static final long serialVersionUID = 1L;
    public static final LocalDateSerializer INSTANCE = new LocalDateSerializer();

    protected LocalDateSerializer() {
        super(LocalDate.class);
    }

    protected LocalDateSerializer(LocalDateSerializer base, Boolean useTimestamp, DateTimeFormatter dtf, JsonFormat.Shape shape) {
        super(base, useTimestamp, dtf, shape);
    }

    public LocalDateSerializer(DateTimeFormatter formatter2) {
        super(LocalDate.class, formatter2);
    }

    protected LocalDateSerializer withFormat(Boolean useTimestamp, DateTimeFormatter dtf, JsonFormat.Shape shape) {
        return new LocalDateSerializer(this, useTimestamp, dtf, shape);
    }

    @Override
    public void serialize(LocalDate date, JsonGenerator g, SerializerProvider provider) throws IOException {
        if (this.useTimestamp(provider)) {
            if (this._shape == JsonFormat.Shape.NUMBER_INT) {
                g.writeNumber(date.toEpochDay());
            } else {
                g.writeStartArray();
                this._serializeAsArrayContents(date, g, provider);
                g.writeEndArray();
            }
        } else {
            g.writeString(this._formatter == null ? date.toString() : date.format(this._formatter));
        }
    }

    @Override
    public void serializeWithType(LocalDate value2, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value2, this.serializationShape(provider)));
        switch (typeIdDef.valueShape) {
            case START_ARRAY: {
                this._serializeAsArrayContents(value2, g, provider);
                break;
            }
            case VALUE_NUMBER_INT: {
                g.writeNumber(value2.toEpochDay());
                break;
            }
            default: {
                g.writeString(this._formatter == null ? value2.toString() : value2.format(this._formatter));
            }
        }
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    protected void _serializeAsArrayContents(LocalDate value2, JsonGenerator g, SerializerProvider provider) throws IOException {
        g.writeNumber(value2.getYear());
        g.writeNumber(value2.getMonthValue());
        g.writeNumber(value2.getDayOfMonth());
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        boolean useTimestamp;
        SerializerProvider provider = visitor.getProvider();
        boolean bl = useTimestamp = provider != null && this.useTimestamp(provider);
        if (useTimestamp) {
            this._acceptTimestampVisitor(visitor, typeHint);
        } else {
            JsonStringFormatVisitor v2 = visitor.expectStringFormat(typeHint);
            if (v2 != null) {
                v2.format(JsonValueFormat.DATE);
            }
        }
    }

    @Override
    protected JsonToken serializationShape(SerializerProvider provider) {
        if (this.useTimestamp(provider)) {
            if (this._shape == JsonFormat.Shape.NUMBER_INT) {
                return JsonToken.VALUE_NUMBER_INT;
            }
            return JsonToken.START_ARRAY;
        }
        return JsonToken.VALUE_STRING;
    }
}

