/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.datatype.jsr310.ser;

import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.annotation.JsonFormat;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.core.JsonGenerator;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.core.JsonToken;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.core.type.WritableTypeId;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.JavaType;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.JsonMappingException;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.SerializerProvider;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;
import java.io.IOException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;

public class LocalTimeSerializer
extends JSR310FormattedSerializerBase<LocalTime> {
    private static final long serialVersionUID = 1L;
    public static final LocalTimeSerializer INSTANCE = new LocalTimeSerializer();

    protected LocalTimeSerializer() {
        this((DateTimeFormatter)null);
    }

    public LocalTimeSerializer(DateTimeFormatter formatter2) {
        super(LocalTime.class, formatter2);
    }

    protected LocalTimeSerializer(LocalTimeSerializer base, Boolean useTimestamp, DateTimeFormatter formatter2) {
        this(base, useTimestamp, null, formatter2);
    }

    protected LocalTimeSerializer(LocalTimeSerializer base, Boolean useTimestamp, Boolean useNanoseconds, DateTimeFormatter formatter2) {
        super(base, useTimestamp, useNanoseconds, formatter2, null);
    }

    @Override
    protected JSR310FormattedSerializerBase<LocalTime> withFormat(Boolean useTimestamp, DateTimeFormatter dtf, JsonFormat.Shape shape) {
        return new LocalTimeSerializer(this, useTimestamp, dtf);
    }

    protected DateTimeFormatter _defaultFormatter() {
        return DateTimeFormatter.ISO_LOCAL_TIME;
    }

    @Override
    public void serialize(LocalTime value2, JsonGenerator g, SerializerProvider provider) throws IOException {
        if (this.useTimestamp(provider)) {
            g.writeStartArray();
            this._serializeAsArrayContents(value2, g, provider);
            g.writeEndArray();
        } else {
            DateTimeFormatter dtf = this._formatter;
            if (dtf == null) {
                dtf = this._defaultFormatter();
            }
            g.writeString(value2.format(dtf));
        }
    }

    @Override
    public void serializeWithType(LocalTime value2, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value2, this.serializationShape(provider)));
        if (typeIdDef.valueShape == JsonToken.START_ARRAY) {
            this._serializeAsArrayContents(value2, g, provider);
        } else {
            DateTimeFormatter dtf = this._formatter;
            if (dtf == null) {
                dtf = this._defaultFormatter();
            }
            g.writeString(value2.format(dtf));
        }
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    private final void _serializeAsArrayContents(LocalTime value2, JsonGenerator g, SerializerProvider provider) throws IOException {
        g.writeNumber(value2.getHour());
        g.writeNumber(value2.getMinute());
        int secs = value2.getSecond();
        int nanos = value2.getNano();
        if (secs > 0 || nanos > 0) {
            g.writeNumber(secs);
            if (nanos > 0) {
                if (this.useNanoseconds(provider)) {
                    g.writeNumber(nanos);
                } else {
                    g.writeNumber(value2.get(ChronoField.MILLI_OF_SECOND));
                }
            }
        }
    }

    @Override
    protected JsonToken serializationShape(SerializerProvider provider) {
        return this.useTimestamp(provider) ? JsonToken.START_ARRAY : JsonToken.VALUE_STRING;
    }

    @Override
    protected JSR310FormattedSerializerBase<?> withFeatures(Boolean writeZoneId, Boolean writeNanoseconds) {
        return new LocalTimeSerializer(this, this._useTimestamp, writeNanoseconds, this._formatter);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        if (this.useTimestamp(visitor.getProvider())) {
            this._acceptTimestampVisitor(visitor, typeHint);
        } else {
            JsonStringFormatVisitor v2 = visitor.expectStringFormat(typeHint);
            if (v2 != null) {
                v2.format(JsonValueFormat.TIME);
            }
        }
    }
}

