/*
 * Decompiled with CFR 0.152.
 */
package io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.datatype.jsr310.ser.key;

import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.core.JsonGenerator;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.core.JsonProcessingException;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.JsonSerializer;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.SerializationFeature;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.databind.SerializerProvider;
import io.github.quiltservertools.blockbotdiscord.libs.com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class ZonedDateTimeKeySerializer
extends JsonSerializer<ZonedDateTime> {
    public static final ZonedDateTimeKeySerializer INSTANCE = new ZonedDateTimeKeySerializer();

    private ZonedDateTimeKeySerializer() {
    }

    @Override
    public void serialize(ZonedDateTime value2, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        if (serializers.isEnabled(SerializationFeature.WRITE_DATES_WITH_ZONE_ID)) {
            gen.writeFieldName(DateTimeFormatter.ISO_ZONED_DATE_TIME.format(value2));
        } else if (ZonedDateTimeKeySerializer.useTimestamps(serializers)) {
            if (ZonedDateTimeKeySerializer.useNanos(serializers)) {
                gen.writeFieldName(DecimalUtils.toBigDecimal(value2.toEpochSecond(), value2.getNano()).toString());
            } else {
                gen.writeFieldName(String.valueOf(value2.toInstant().toEpochMilli()));
            }
        } else {
            gen.writeFieldName(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(value2));
        }
    }

    private static boolean useNanos(SerializerProvider serializers) {
        return serializers.isEnabled(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS);
    }

    private static boolean useTimestamps(SerializerProvider serializers) {
        return serializers.isEnabled(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS);
    }
}

